/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.server.http;

import io.gravitee.node.vertx.server.VertxServerOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class VertxHttpServerOptions
extends VertxServerOptions {
    private static final Logger log = LoggerFactory.getLogger(VertxHttpServerOptions.class);
    public static final String HTTP_PREFIX = "http";
    public static final boolean DEFAULT_WEBSOCKET_ENABLED = false;
    public static final boolean DEFAULT_ALPN = false;
    public static final boolean DEFAULT_HANDLE_100_CONTINUE = false;
    public static final String DEFAULT_TRACING_POLICY = HttpServerOptions.DEFAULT_TRACING_POLICY.name();
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_FORM_ATTRIBUTE_SIZE = 8192;
    public static final boolean DEFAULT_COMPRESSION_SUPPORTED = false;
    public static final boolean DEFAULT_PER_MESSAGE_WEBSOCKET_COMPRESSION_SUPPORTED = true;
    public static final boolean DEFAULT_PER_FRAME_WEBSOCKET_COMPRESSION_SUPPORTED = true;
    public static final int DEFAULT_MAX_WEBSOCKET_MESSAGE_SIZE = 262144;
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    protected boolean alpn;
    private String tracingPolicy;
    private boolean handle100Continue;
    private int maxHeaderSize;
    private int maxChunkSize;
    private int maxInitialLineLength;
    private int maxFormAttributeSize;
    protected boolean compressionSupported;
    private boolean websocketEnabled;
    private String websocketSubProtocols;
    private boolean perMessageWebSocketCompressionSupported;
    private boolean perFrameWebSocketCompressionSupported;
    private int maxWebSocketFrameSize;
    private int maxWebSocketMessageSize;

    public HttpServerOptions createHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        if (this.tracingPolicy != null) {
            options.setTracingPolicy(TracingPolicy.valueOf((String)this.tracingPolicy.toUpperCase()));
        }
        options.setPort(this.port);
        options.setHost(this.host);
        this.setupTcp((TCPSSLOptions)options);
        if (this.secured) {
            options.setUseAlpn(this.alpn);
            options.setSni(this.sni);
            options.setClientAuth(ClientAuth.valueOf((String)this.clientAuth));
        }
        if (this.haProxyProtocol) {
            options.setUseProxyProtocol(true).setProxyProtocolTimeout(this.haProxyProtocolTimeout);
        }
        options.setHandle100ContinueAutomatically(this.handle100Continue);
        options.setCompressionSupported(this.compressionSupported);
        options.setMaxChunkSize(this.maxChunkSize);
        options.setMaxHeaderSize(this.maxHeaderSize);
        options.getInitialSettings().setMaxHeaderListSize((long)this.maxHeaderSize);
        options.setMaxInitialLineLength(this.maxInitialLineLength);
        options.setMaxFormAttributeSize(this.maxFormAttributeSize);
        if (this.websocketEnabled) {
            options.setMaxWebSocketFrameSize(this.maxWebSocketFrameSize);
            options.setMaxWebSocketMessageSize(this.maxWebSocketMessageSize);
            options.setPerMessageWebSocketCompressionSupported(this.perMessageWebSocketCompressionSupported);
            options.setPerFrameWebSocketCompressionSupported(this.perFrameWebSocketCompressionSupported);
            if (this.websocketSubProtocols != null) {
                options.setWebSocketSubProtocols(Arrays.stream(this.websocketSubProtocols.split(",")).map(String::trim).toList());
            }
        } else {
            options.setPerMessageWebSocketCompressionSupported(false);
            options.setPerFrameWebSocketCompressionSupported(false);
        }
        return options;
    }

    private static boolean $default$alpn() {
        return false;
    }

    private static String $default$tracingPolicy() {
        return DEFAULT_TRACING_POLICY;
    }

    private static boolean $default$handle100Continue() {
        return false;
    }

    private static int $default$maxHeaderSize() {
        return 8192;
    }

    private static int $default$maxChunkSize() {
        return 8192;
    }

    private static int $default$maxInitialLineLength() {
        return 4096;
    }

    private static int $default$maxFormAttributeSize() {
        return 8192;
    }

    private static boolean $default$compressionSupported() {
        return false;
    }

    private static boolean $default$websocketEnabled() {
        return false;
    }

    private static boolean $default$perMessageWebSocketCompressionSupported() {
        return true;
    }

    private static boolean $default$perFrameWebSocketCompressionSupported() {
        return true;
    }

    private static int $default$maxWebSocketFrameSize() {
        return 65536;
    }

    private static int $default$maxWebSocketMessageSize() {
        return 262144;
    }

    protected VertxHttpServerOptions(VertxHttpServerOptionsBuilder<?, ?> b) {
        super(b);
        this.alpn = b.alpn$set ? b.alpn$value : VertxHttpServerOptions.$default$alpn();
        this.tracingPolicy = b.tracingPolicy$set ? b.tracingPolicy$value : VertxHttpServerOptions.$default$tracingPolicy();
        this.handle100Continue = b.handle100Continue$set ? b.handle100Continue$value : VertxHttpServerOptions.$default$handle100Continue();
        this.maxHeaderSize = b.maxHeaderSize$set ? b.maxHeaderSize$value : VertxHttpServerOptions.$default$maxHeaderSize();
        this.maxChunkSize = b.maxChunkSize$set ? b.maxChunkSize$value : VertxHttpServerOptions.$default$maxChunkSize();
        this.maxInitialLineLength = b.maxInitialLineLength$set ? b.maxInitialLineLength$value : VertxHttpServerOptions.$default$maxInitialLineLength();
        this.maxFormAttributeSize = b.maxFormAttributeSize$set ? b.maxFormAttributeSize$value : VertxHttpServerOptions.$default$maxFormAttributeSize();
        this.compressionSupported = b.compressionSupported$set ? b.compressionSupported$value : VertxHttpServerOptions.$default$compressionSupported();
        this.websocketEnabled = b.websocketEnabled$set ? b.websocketEnabled$value : VertxHttpServerOptions.$default$websocketEnabled();
        this.websocketSubProtocols = b.websocketSubProtocols;
        this.perMessageWebSocketCompressionSupported = b.perMessageWebSocketCompressionSupported$set ? b.perMessageWebSocketCompressionSupported$value : VertxHttpServerOptions.$default$perMessageWebSocketCompressionSupported();
        this.perFrameWebSocketCompressionSupported = b.perFrameWebSocketCompressionSupported$set ? b.perFrameWebSocketCompressionSupported$value : VertxHttpServerOptions.$default$perFrameWebSocketCompressionSupported();
        this.maxWebSocketFrameSize = b.maxWebSocketFrameSize$set ? b.maxWebSocketFrameSize$value : VertxHttpServerOptions.$default$maxWebSocketFrameSize();
        this.maxWebSocketMessageSize = b.maxWebSocketMessageSize$set ? b.maxWebSocketMessageSize$value : VertxHttpServerOptions.$default$maxWebSocketMessageSize();
    }

    public static VertxHttpServerOptionsBuilder<?, ?> builder() {
        return new VertxHttpServerOptionsBuilderImpl();
    }

    public boolean isAlpn() {
        return this.alpn;
    }

    public String getTracingPolicy() {
        return this.tracingPolicy;
    }

    public boolean isHandle100Continue() {
        return this.handle100Continue;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int getMaxFormAttributeSize() {
        return this.maxFormAttributeSize;
    }

    public boolean isCompressionSupported() {
        return this.compressionSupported;
    }

    public boolean isWebsocketEnabled() {
        return this.websocketEnabled;
    }

    public String getWebsocketSubProtocols() {
        return this.websocketSubProtocols;
    }

    public boolean isPerMessageWebSocketCompressionSupported() {
        return this.perMessageWebSocketCompressionSupported;
    }

    public boolean isPerFrameWebSocketCompressionSupported() {
        return this.perFrameWebSocketCompressionSupported;
    }

    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    public int getMaxWebSocketMessageSize() {
        return this.maxWebSocketMessageSize;
    }

    public static abstract class VertxHttpServerOptionsBuilder<C extends VertxHttpServerOptions, B extends VertxHttpServerOptionsBuilder<C, B>>
    extends VertxServerOptions.VertxServerOptionsBuilder<C, B> {
        private boolean alpn$set;
        private boolean alpn$value;
        private boolean tracingPolicy$set;
        private String tracingPolicy$value;
        private boolean handle100Continue$set;
        private boolean handle100Continue$value;
        private boolean maxHeaderSize$set;
        private int maxHeaderSize$value;
        private boolean maxChunkSize$set;
        private int maxChunkSize$value;
        private boolean maxInitialLineLength$set;
        private int maxInitialLineLength$value;
        private boolean maxFormAttributeSize$set;
        private int maxFormAttributeSize$value;
        private boolean compressionSupported$set;
        private boolean compressionSupported$value;
        private boolean websocketEnabled$set;
        private boolean websocketEnabled$value;
        private String websocketSubProtocols;
        private boolean perMessageWebSocketCompressionSupported$set;
        private boolean perMessageWebSocketCompressionSupported$value;
        private boolean perFrameWebSocketCompressionSupported$set;
        private boolean perFrameWebSocketCompressionSupported$value;
        private boolean maxWebSocketFrameSize$set;
        private int maxWebSocketFrameSize$value;
        private boolean maxWebSocketMessageSize$set;
        private int maxWebSocketMessageSize$value;

        @Override
        public B environment(Environment environment) {
            super.environment(environment);
            this.alpn((Boolean)environment.getProperty(this.prefix + ".alpn", Boolean.class, (Object)false));
            this.tracingPolicy(environment.getProperty(this.prefix + ".tracingPolicy", DEFAULT_TRACING_POLICY));
            this.handle100Continue((Boolean)environment.getProperty(this.prefix + ".handle100Continue", Boolean.class, (Object)false));
            this.maxHeaderSize((Integer)environment.getProperty(this.prefix + ".maxHeaderSize", Integer.class, (Object)8192));
            this.maxChunkSize((Integer)environment.getProperty(this.prefix + ".maxChunkSize", Integer.class, (Object)8192));
            this.maxInitialLineLength((Integer)environment.getProperty(this.prefix + ".maxInitialLineLength", Integer.class, (Object)4096));
            this.maxFormAttributeSize((Integer)environment.getProperty(this.prefix + ".maxFormAttributeSize", Integer.class, (Object)8192));
            this.compressionSupported((Boolean)environment.getProperty(this.prefix + ".compressionSupported", Boolean.class, (Object)false));
            this.websocketEnabled((Boolean)environment.getProperty(this.prefix + ".websocket.enabled", Boolean.class, (Object)false));
            this.websocketSubProtocols(environment.getProperty(this.prefix + ".websocket.subProtocols"));
            this.perMessageWebSocketCompressionSupported((Boolean)environment.getProperty(this.prefix + ".websocket.perMessageWebSocketCompressionSupported", Boolean.class, (Object)true));
            this.perFrameWebSocketCompressionSupported((Boolean)environment.getProperty(this.prefix + ".websocket.perFrameWebSocketCompressionSupported", Boolean.class, (Object)true));
            this.maxWebSocketMessageSize((Integer)environment.getProperty(this.prefix + ".websocket.maxWebSocketMessageSize", Integer.class, (Object)262144));
            this.maxWebSocketFrameSize((Integer)environment.getProperty(this.prefix + ".websocket.maxWebSocketFrameSize", Integer.class, (Object)65536));
            return (B)this.self();
        }

        public B alpn(boolean alpn) {
            this.alpn$value = alpn;
            this.alpn$set = true;
            return (B)this.self();
        }

        public B tracingPolicy(String tracingPolicy) {
            this.tracingPolicy$value = tracingPolicy;
            this.tracingPolicy$set = true;
            return (B)this.self();
        }

        public B handle100Continue(boolean handle100Continue) {
            this.handle100Continue$value = handle100Continue;
            this.handle100Continue$set = true;
            return (B)this.self();
        }

        public B maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize$value = maxHeaderSize;
            this.maxHeaderSize$set = true;
            return (B)this.self();
        }

        public B maxChunkSize(int maxChunkSize) {
            this.maxChunkSize$value = maxChunkSize;
            this.maxChunkSize$set = true;
            return (B)this.self();
        }

        public B maxInitialLineLength(int maxInitialLineLength) {
            this.maxInitialLineLength$value = maxInitialLineLength;
            this.maxInitialLineLength$set = true;
            return (B)this.self();
        }

        public B maxFormAttributeSize(int maxFormAttributeSize) {
            this.maxFormAttributeSize$value = maxFormAttributeSize;
            this.maxFormAttributeSize$set = true;
            return (B)this.self();
        }

        public B compressionSupported(boolean compressionSupported) {
            this.compressionSupported$value = compressionSupported;
            this.compressionSupported$set = true;
            return (B)this.self();
        }

        public B websocketEnabled(boolean websocketEnabled) {
            this.websocketEnabled$value = websocketEnabled;
            this.websocketEnabled$set = true;
            return (B)this.self();
        }

        public B websocketSubProtocols(String websocketSubProtocols) {
            this.websocketSubProtocols = websocketSubProtocols;
            return (B)this.self();
        }

        public B perMessageWebSocketCompressionSupported(boolean perMessageWebSocketCompressionSupported) {
            this.perMessageWebSocketCompressionSupported$value = perMessageWebSocketCompressionSupported;
            this.perMessageWebSocketCompressionSupported$set = true;
            return (B)this.self();
        }

        public B perFrameWebSocketCompressionSupported(boolean perFrameWebSocketCompressionSupported) {
            this.perFrameWebSocketCompressionSupported$value = perFrameWebSocketCompressionSupported;
            this.perFrameWebSocketCompressionSupported$set = true;
            return (B)this.self();
        }

        public B maxWebSocketFrameSize(int maxWebSocketFrameSize) {
            this.maxWebSocketFrameSize$value = maxWebSocketFrameSize;
            this.maxWebSocketFrameSize$set = true;
            return (B)this.self();
        }

        public B maxWebSocketMessageSize(int maxWebSocketMessageSize) {
            this.maxWebSocketMessageSize$value = maxWebSocketMessageSize;
            this.maxWebSocketMessageSize$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VertxHttpServerOptions.VertxHttpServerOptionsBuilder(super=" + super.toString() + ", alpn$value=" + this.alpn$value + ", tracingPolicy$value=" + this.tracingPolicy$value + ", handle100Continue$value=" + this.handle100Continue$value + ", maxHeaderSize$value=" + this.maxHeaderSize$value + ", maxChunkSize$value=" + this.maxChunkSize$value + ", maxInitialLineLength$value=" + this.maxInitialLineLength$value + ", maxFormAttributeSize$value=" + this.maxFormAttributeSize$value + ", compressionSupported$value=" + this.compressionSupported$value + ", websocketEnabled$value=" + this.websocketEnabled$value + ", websocketSubProtocols=" + this.websocketSubProtocols + ", perMessageWebSocketCompressionSupported$value=" + this.perMessageWebSocketCompressionSupported$value + ", perFrameWebSocketCompressionSupported$value=" + this.perFrameWebSocketCompressionSupported$value + ", maxWebSocketFrameSize$value=" + this.maxWebSocketFrameSize$value + ", maxWebSocketMessageSize$value=" + this.maxWebSocketMessageSize$value + ")";
        }
    }

    private static final class VertxHttpServerOptionsBuilderImpl
    extends VertxHttpServerOptionsBuilder<VertxHttpServerOptions, VertxHttpServerOptionsBuilderImpl> {
        private VertxHttpServerOptionsBuilderImpl() {
        }

        @Override
        protected VertxHttpServerOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public VertxHttpServerOptions build() {
            return new VertxHttpServerOptions(this);
        }
    }
}

