/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx;

import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.cert.VertxCertificateManager;
import io.gravitee.node.vertx.configuration.HttpServerConfiguration;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SelfSignedCertificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractVertxHttpServerFactory<T>
implements FactoryBean<T> {
    private final HttpServerConfiguration httpServerConfiguration;
    private final KeyStoreLoaderManager keyStoreLoaderManager;

    public AbstractVertxHttpServerFactory(HttpServerConfiguration httpServerConfiguration, KeyStoreLoaderManager keyStoreLoaderManager) {
        this.httpServerConfiguration = httpServerConfiguration;
        this.keyStoreLoaderManager = keyStoreLoaderManager;
    }

    protected HttpServerOptions getHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setTracingPolicy(this.httpServerConfiguration.getTracingPolicy());
        options.setPort(this.httpServerConfiguration.getPort());
        options.setHost(this.httpServerConfiguration.getHost());
        if (this.httpServerConfiguration.isSecured()) {
            if (this.keyStoreLoaderManager == null) {
                throw new IllegalArgumentException("You must provide a KeyStoreLoaderManager when 'secured' is enabled.");
            }
            if (this.httpServerConfiguration.isOpenssl()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
            options.setSsl(this.httpServerConfiguration.isSecured());
            options.setUseAlpn(this.httpServerConfiguration.isAlpn());
            options.setSni(this.httpServerConfiguration.isSni());
            if (this.httpServerConfiguration.getTlsProtocols() != null) {
                options.setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList(this.httpServerConfiguration.getTlsProtocols().split("\\s*,\\s*"))));
            }
            if (this.httpServerConfiguration.getAuthorizedTlsCipherSuites() != null) {
                this.httpServerConfiguration.getAuthorizedTlsCipherSuites().stream().map(String::trim).forEach(arg_0 -> ((HttpServerOptions)options).addEnabledCipherSuite(arg_0));
            }
            options.setClientAuth(this.httpServerConfiguration.getClientAuth());
            if (this.httpServerConfiguration.getTrustStorePaths() != null && !this.httpServerConfiguration.getTrustStorePaths().isEmpty()) {
                if (this.httpServerConfiguration.getTrustStoreType() == null || this.httpServerConfiguration.getTrustStoreType().isEmpty() || this.httpServerConfiguration.getTrustStoreType().equalsIgnoreCase("JKS")) {
                    options.setTrustStoreOptions(new JksOptions().setPath(this.httpServerConfiguration.getTrustStorePaths().get(0)).setPassword(this.httpServerConfiguration.getTrustStorePassword()));
                } else if (this.httpServerConfiguration.getTrustStoreType().equalsIgnoreCase("PEM")) {
                    PemTrustOptions pemTrustOptions = new PemTrustOptions();
                    this.httpServerConfiguration.getTrustStorePaths().forEach(arg_0 -> ((PemTrustOptions)pemTrustOptions).addCertPath(arg_0));
                    options.setPemTrustOptions(pemTrustOptions);
                } else if (this.httpServerConfiguration.getTrustStoreType().equalsIgnoreCase("PKCS12")) {
                    options.setPfxTrustOptions(new PfxOptions().setPath(this.httpServerConfiguration.getTrustStorePaths().get(0)).setPassword(this.httpServerConfiguration.getTrustStorePassword()));
                }
            } else if ("SELF-SIGNED".equalsIgnoreCase(this.httpServerConfiguration.getTrustStoreType())) {
                options.setPemTrustOptions(SelfSignedCertificate.create().trustOptions());
            }
            KeyStoreLoaderOptions keyStoreLoaderOptions = KeyStoreLoaderOptions.builder().withKeyStorePath(this.httpServerConfiguration.getKeyStorePath()).withKeyStorePassword(this.httpServerConfiguration.getKeyStorePassword()).withKeyStoreType(this.httpServerConfiguration.getKeyStoreType()).withKeyStoreCertificates(this.httpServerConfiguration.getKeyStoreCertificates()).withKubernetesLocations(this.httpServerConfiguration.getKeystoreKubernetes()).withWatch(true).withDefaultAlias(this.httpServerConfiguration.getKeyStoreDefaultAlias()).build();
            VertxCertificateManager certificateManager = new VertxCertificateManager(this.httpServerConfiguration.isSni());
            KeyStoreLoader keyStoreLoader = this.keyStoreLoaderManager.create(keyStoreLoaderOptions);
            certificateManager.registerLoader(keyStoreLoader);
            options.setKeyCertOptions(certificateManager.getKeyCertOptions());
            keyStoreLoader.start();
        }
        if (this.httpServerConfiguration.isProxyProtocol()) {
            options.setUseProxyProtocol(true).setProxyProtocolTimeout(this.httpServerConfiguration.getProxyProtocolTimeout());
        }
        options.setHandle100ContinueAutomatically(this.httpServerConfiguration.isHandle100Continue());
        options.setCompressionSupported(this.httpServerConfiguration.isCompressionSupported());
        options.setIdleTimeout(this.httpServerConfiguration.getIdleTimeout());
        options.setTcpKeepAlive(this.httpServerConfiguration.isTcpKeepAlive());
        options.setMaxChunkSize(this.httpServerConfiguration.getMaxChunkSize());
        options.setMaxHeaderSize(this.httpServerConfiguration.getMaxHeaderSize());
        options.setMaxInitialLineLength(this.httpServerConfiguration.getMaxInitialLineLength());
        options.setMaxFormAttributeSize(this.httpServerConfiguration.getMaxFormAttributeSize());
        System.setProperty("vertx.disableWebsockets", Boolean.toString(!this.httpServerConfiguration.isWebsocketEnabled()));
        if (this.httpServerConfiguration.isWebsocketEnabled() && this.httpServerConfiguration.getWebsocketSubProtocols() != null) {
            options.setWebSocketSubProtocols(new ArrayList<String>(Arrays.asList(this.httpServerConfiguration.getWebsocketSubProtocols().split("\\s*,\\s*"))));
            options.setPerMessageWebSocketCompressionSupported(this.httpServerConfiguration.isPerMessageWebSocketCompressionSupported());
            options.setPerFrameWebSocketCompressionSupported(this.httpServerConfiguration.isPerFrameWebSocketCompressionSupported());
        }
        if (this.httpServerConfiguration.isWebsocketEnabled()) {
            options.setMaxWebSocketFrameSize(this.httpServerConfiguration.getMaxWebSocketFrameSize());
            options.setMaxWebSocketMessageSize(this.httpServerConfiguration.getMaxWebSocketMessageSize());
        }
        return options;
    }
}

