/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.service.conf;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.node.api.secrets.SecretManagerConfiguration;
import io.gravitee.node.api.secrets.errors.SecretManagerConfigurationException;
import io.gravitee.node.api.secrets.errors.SecretManagerException;
import io.gravitee.node.api.secrets.errors.SecretProviderNotFoundException;
import io.gravitee.node.api.secrets.model.Secret;
import io.gravitee.node.api.secrets.model.SecretLocation;
import io.gravitee.node.api.secrets.model.SecretMap;
import io.gravitee.node.api.secrets.model.SecretMount;
import io.gravitee.node.api.secrets.model.SecretURL;
import io.gravitee.node.api.secrets.util.ConfigHelper;
import io.gravitee.node.secrets.plugins.SecretProviderPluginManager;
import io.gravitee.node.secrets.service.AbstractSecretProviderDispatcher;
import io.reactivex.rxjava3.core.Maybe;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class GraviteeConfigurationSecretResolverDispatcher
extends AbstractSecretProviderDispatcher {
    private static final Logger log = LoggerFactory.getLogger(GraviteeConfigurationSecretResolverDispatcher.class);
    private static final String SECRETS_CONFIG_KEY = "secrets";
    private final Environment environment;
    private final Map<SecretLocation, SecretMap> secrets = Collections.synchronizedMap(new HashMap());
    private final List<String> enabledProviders = new ArrayList<String>();

    public GraviteeConfigurationSecretResolverDispatcher(SecretProviderPluginManager secretProviderPluginManager, Environment environment) {
        super(secretProviderPluginManager);
        this.environment = environment;
        this.setupConverters((ConfigurableEnvironment)environment);
        secretProviderPluginManager.setOnNewPluginCallback(pluginId -> {
            if (this.isEnabled((String)pluginId)) {
                super.createAndRegister((String)pluginId);
                this.enabledProviders.add((String)pluginId);
            }
        });
    }

    private void setupConverters(ConfigurableEnvironment environment) {
        environment.getConversionService().addConverter((Converter)new Converter<Secret, String>(){

            public String convert(@Nonnull Secret source) {
                return source.asString();
            }
        });
        environment.getConversionService().addConverter((Converter)new Converter<Secret, byte[]>(){

            public byte[] convert(@Nonnull Secret source) {
                return source.asBytes();
            }
        });
    }

    @Override
    public boolean isEnabled(String pluginId) {
        return (Boolean)this.environment.getProperty(String.format("%s.%s.enabled", SECRETS_CONFIG_KEY, pluginId), Boolean.TYPE, (Object)false);
    }

    public <T extends SecretManagerConfiguration> T readConfiguration(String pluginId, Class<?> configurationClass) {
        Map configurationProperties = ConfigHelper.removePrefix((Map)EnvironmentUtils.getAllProperties((ConfigurableEnvironment)((ConfigurableEnvironment)this.environment)), (String)"%s.%s".formatted(SECRETS_CONFIG_KEY, pluginId));
        try {
            Constructor<?> constructor = configurationClass.getDeclaredConstructor(Map.class);
            return (T)((SecretManagerConfiguration)constructor.newInstance(configurationProperties));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SecretManagerConfigurationException("Could not create configuration class for secret manager: %s".formatted(pluginId), (Throwable)e);
        }
    }

    @Override
    public Maybe<SecretMap> resolve(SecretMount secretMount) throws SecretProviderNotFoundException, SecretManagerException {
        if (this.secrets.containsKey(secretMount.location())) {
            return Maybe.just((Object)this.secrets.get(secretMount.location()));
        }
        return super.resolve(secretMount).doOnSuccess(secretMap -> this.secrets.put(secretMount.location(), (SecretMap)secretMap));
    }

    public boolean canHandle(String location) {
        Objects.requireNonNull(location);
        return location.startsWith("secret://") && this.enabledProviders().stream().anyMatch(manager -> GraviteeConfigurationSecretResolverDispatcher.canProviderHandle(location, manager));
    }

    public boolean canResolveSingleValue(String location) {
        Objects.requireNonNull(location);
        if (this.canHandle(location)) {
            try {
                SecretMount secretMount = this.toSecretMount(location);
                if (secretMount.isKeyEmpty()) {
                    throw new IllegalArgumentException("Secret URL should must specify a 'key' in order to resolve a single value, such as: %s:<KEY>".formatted(location));
                }
                return true;
            }
            catch (SecretProviderNotFoundException | IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public SecretMount toSecretMount(String location) {
        SecretURL url = SecretURL.from((String)location);
        return this.findSecretProvider(url.provider()).map(secretProvider -> {
            try {
                return secretProvider.fromURL(url);
            }
            catch (IllegalArgumentException e) {
                throw new SecretManagerConfigurationException("cannot create secret URL from: " + location, (Throwable)e);
            }
        }).orElseThrow(() -> new SecretProviderNotFoundException("No secret-provider plugin found for provider id: '%s'".formatted(url.provider())));
    }

    Map<SecretLocation, SecretMap> secrets() {
        return Map.copyOf(this.secrets);
    }

    private static boolean canProviderHandle(String location, String manager) {
        return location.startsWith("%s%s/".formatted("secret://", manager));
    }

    public List<String> enabledProviders() {
        return this.enabledProviders;
    }
}

