/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.reporter.vertx.verticle;

import io.gravitee.node.reporter.ReporterService;
import io.gravitee.node.reporter.vertx.eventbus.ReportableMessageCodec;
import io.gravitee.reporter.api.Reportable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.tracing.TracingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterVerticle
extends AbstractVerticle
implements ReporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReporterVerticle.class);
    private static final String EVENT_BUS_ADDRESS = "node:metrics";
    private MessageProducer<Reportable> producer;

    public void start(Promise<Void> promise) throws Exception {
        this.vertx.eventBus().registerCodec((MessageCodec)new ReportableMessageCodec());
        this.producer = this.vertx.eventBus().publisher(EVENT_BUS_ADDRESS, new DeliveryOptions().setCodecName("reportable-codec").setTracingPolicy(TracingPolicy.IGNORE));
        this.vertx.eventBus().localConsumer("gio:node:monitor", event -> this.producer.write((Object)((Reportable)event.body())));
        promise.complete();
    }

    public void stop(Promise<Void> promise) throws Exception {
        if (this.producer != null) {
            this.producer.close(event -> {
                if (event.succeeded()) {
                    LOGGER.debug("Reporter publisher has been closed successfully.");
                    promise.complete();
                } else {
                    promise.fail(event.cause());
                }
            });
        } else {
            promise.complete();
        }
    }

    @Override
    public void report(Reportable reportable) {
        if (this.producer != null) {
            this.producer.write((Object)reportable);
        }
    }
}

