/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.reporter.vertx.eventbus;

import io.gravitee.reporter.api.Reportable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ReportableMessageCodec
implements MessageCodec<Reportable, Reportable> {
    public static final String CODEC_NAME = "reportable-codec";

    public void encodeToWire(Buffer buffer, Reportable reportable) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(reportable);
            oos.flush();
            byte[] data = bos.toByteArray();
            int length = data.length;
            buffer.appendInt(length);
            buffer.appendBytes(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Reportable decodeFromWire(int position, Buffer buffer) {
        try {
            int pos = position;
            int length = buffer.getInt(pos);
            byte[] data = buffer.getBytes(pos += 4, pos += length);
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            return (Reportable)is.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Reportable transform(Reportable reportable) {
        return reportable;
    }

    public String name() {
        return CODEC_NAME;
    }

    public byte systemCodecID() {
        return -1;
    }
}

