/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.vertx.configuration;

import io.gravitee.node.api.configuration.Configuration;

public class HttpServerConfiguration {
    private final Configuration configuration;

    public boolean isEnabled() {
        return (Boolean)this.configuration.getProperty("services.core.http.enabled", Boolean.class, (Object)true);
    }

    public int getPort() {
        return (Integer)this.configuration.getProperty("services.core.http.port", Integer.class, (Object)18082);
    }

    public String getHost() {
        return this.configuration.getProperty("services.core.http.host", "localhost");
    }

    public String getAuthenticationType() {
        return this.configuration.getProperty("services.core.http.authentication.type", "basic");
    }

    public boolean isSecured() {
        return (Boolean)this.configuration.getProperty("services.core.http.secured", Boolean.class, (Object)false);
    }

    public boolean isAlpn() {
        return (Boolean)this.configuration.getProperty("services.core.http.alpn", Boolean.class, (Object)false);
    }

    public String getTlsProtocols() {
        return this.configuration.getProperty("services.core.http.ssl.tlsProtocols");
    }

    public String getTlsCiphers() {
        return this.configuration.getProperty("services.core.http.ssl.tlsCiphers");
    }

    public String getKeyStorePath() {
        return this.configuration.getProperty("services.core.http.ssl.keystore.path");
    }

    public String getKeyStorePassword() {
        return this.configuration.getProperty("services.core.http.ssl.keystore.password");
    }

    public String getKeyStoreType() {
        return this.configuration.getProperty("services.core.http.ssl.keystore.type");
    }

    public String getTrustStorePath() {
        return this.configuration.getProperty("services.core.http.ssl.truststore.path");
    }

    public String getTrustStorePassword() {
        return this.configuration.getProperty("services.core.http.ssl.truststore.password");
    }

    public String getTrustStoreType() {
        return this.configuration.getProperty("services.core.http.ssl.truststore.type");
    }

    public int getIdleTimeout() {
        return (Integer)this.configuration.getProperty("services.core.http.idleTimeout", Integer.class, (Object)0);
    }

    public String getClientAuth() {
        return this.configuration.getProperty("services.core.http.ssl.clientAuth");
    }

    public HttpServerConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

