/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.node.heap;

import io.gravitee.node.management.http.node.heap.HeapDumpException;
import io.gravitee.node.management.http.node.heap.HeapDumpSupplier;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class OpenJ9HeapDumpSupplier
implements HeapDumpSupplier {
    private Object diagnosticMXBean;
    private Method dumpHeapMethod;

    OpenJ9HeapDumpSupplier() {
        try {
            Class mxBeanClass = ClassUtils.resolveClassName((String)"openj9.lang.management.OpenJ9DiagnosticsMXBean", null);
            this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(mxBeanClass);
            this.dumpHeapMethod = ReflectionUtils.findMethod((Class)mxBeanClass, (String)"triggerDumpToFile", (Class[])new Class[]{String.class, String.class});
        }
        catch (Throwable ex) {
            throw new HeapDumpException("Unable to locate OpenJ9DiagnosticsMXBean", ex);
        }
    }

    @Override
    public void dump(File file, boolean live) throws IOException, InterruptedException {
        ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{"heap", file.getAbsolutePath()});
    }
}

