/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.node.heap;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.node.heap.HeapDumpException;
import io.gravitee.node.management.http.node.heap.HeapDumpSupplier;
import io.gravitee.node.management.http.node.heap.HotSpotHeapDumpSupplier;
import io.gravitee.node.management.http.node.heap.OpenJ9HeapDumpSupplier;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapDumpEndpoint
implements ManagementEndpoint {
    private final Logger LOGGER = LoggerFactory.getLogger(HeapDumpEndpoint.class);
    private final long timeout = TimeUnit.SECONDS.toMillis(10L);
    private final Lock lock = new ReentrantLock();
    private HeapDumpSupplier heapDumpSupplier;

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String path() {
        return "/heapdump";
    }

    @Override
    public void handle(RoutingContext ctx) {
        final HttpServerResponse response = ctx.response();
        final boolean live = Boolean.parseBoolean(ctx.request().getParam("live", Boolean.FALSE.toString()));
        ctx.vertx().executeBlocking((Handler)new Handler<Promise<File>>(){

            public void handle(Promise<File> promise) {
                try {
                    if (HeapDumpEndpoint.this.lock.tryLock(HeapDumpEndpoint.this.timeout, TimeUnit.MILLISECONDS)) {
                        try {
                            File dumpFile = HeapDumpEndpoint.this.dump(live);
                            promise.complete((Object)dumpFile);
                        }
                        catch (Exception e) {
                            promise.fail((Throwable)e);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    promise.fail((Throwable)ex);
                }
                finally {
                    HeapDumpEndpoint.this.lock.unlock();
                }
            }
        }, (Handler)new Handler<AsyncResult<File>>(){

            public void handle(AsyncResult<File> fileAsyncResult) {
                if (fileAsyncResult.succeeded()) {
                    final File file = (File)fileAsyncResult.result();
                    response.setStatusCode(200).setChunked(true).sendFile(file.getAbsolutePath()).onComplete((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> voidAsyncResult) {
                            try {
                                Files.delete(file.toPath());
                            }
                            catch (IOException ex) {
                                HeapDumpEndpoint.this.LOGGER.warn("Failed to delete temporary heap dump file '" + file.toPath() + "'", (Throwable)ex);
                            }
                        }
                    });
                } else {
                    HeapDumpEndpoint.this.LOGGER.error("Unable to generate heap dump.", fileAsyncResult.cause());
                    response.setStatusCode(500).setChunked(true).send(fileAsyncResult.cause().getMessage());
                }
            }
        });
    }

    private File dump(boolean live) throws IOException, InterruptedException {
        if (this.heapDumpSupplier == null) {
            this.heapDumpSupplier = this.createHeapDumpSupplier();
        }
        File file = this.createTempFile();
        this.heapDumpSupplier.dump(file, live);
        return file;
    }

    private File createTempFile() throws IOException {
        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm").format(LocalDateTime.now());
        File file = File.createTempFile("heap-" + date, "." + this.determineDumpSuffix());
        file.delete();
        return file;
    }

    protected HeapDumpSupplier createHeapDumpSupplier() throws HeapDumpException {
        try {
            return new HotSpotHeapDumpSupplier();
        }
        catch (HeapDumpException ex) {
            return new OpenJ9HeapDumpSupplier();
        }
    }

    private String determineDumpSuffix() {
        if (this.heapDumpSupplier instanceof OpenJ9HeapDumpSupplier) {
            return "phd";
        }
        return "hprof";
    }
}

