/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;

public class ConfigurationEndpoint
implements ManagementEndpoint {
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigurationEndpoint.class);
    private static final Set<String> PROPERTY_PREFIXES = new HashSet<String>(Arrays.asList("gravitee.", "gravitee_", "GRAVITEE.", "GRAVITEE_"));
    private static final String ENDPOINT_PATH = "/configuration";
    private static final String PROPERTY_SOURCE_CONFIGURATION = "graviteeYamlConfiguration";
    @Autowired
    private AbstractEnvironment environment;

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String path() {
        return ENDPOINT_PATH;
    }

    @Override
    public void handle(RoutingContext ctx) {
        final HttpServerResponse response = ctx.response();
        response.setStatusCode(200);
        response.putHeader("Content-Type", "application/json");
        response.setChunked(true);
        EnumerablePropertySource nodeConfiguration = (EnumerablePropertySource)this.environment.getPropertySources().get(PROPERTY_SOURCE_CONFIGURATION);
        Map systemEnvironment = this.environment.getSystemEnvironment();
        Map<String, Object> prefixlessSystemEnvironment = systemEnvironment.entrySet().stream().filter(new Predicate<Map.Entry<String, Object>>(){

            @Override
            public boolean test(Map.Entry<String, Object> entry) {
                return entry.getKey().length() > 9 && PROPERTY_PREFIXES.contains(entry.getKey().substring(0, 9));
            }
        }).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(9), Map.Entry::getValue));
        TreeMap nodeProperties = Arrays.stream(nodeConfiguration.getPropertyNames()).collect(Collectors.toMap(s -> s, s -> this.environment.getProperty(s), (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, TreeMap::new));
        nodeProperties.putAll(prefixlessSystemEnvironment);
        DatabindCodec codec = (DatabindCodec)Json.CODEC;
        codec.prettyMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        response.write(Json.CODEC.toString((Object)nodeProperties, true), (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                if (event.failed()) {
                    response.setStatusCode(500);
                    ConfigurationEndpoint.this.LOGGER.error("Unable to transform data object to JSON", event.cause());
                }
                response.end();
            }
        });
    }

    public class Property
    implements Comparable {
        private final String key;
        private final Object value;

        public Property(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            return this.getKey().compareTo(((Property)o).getKey());
        }
    }
}

