/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.vertx.endpoint;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.vertx.ext.web.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ManagementEndpointManagerImpl
implements ManagementEndpointManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementEndpointManagerImpl.class);
    @Autowired
    @Qualifier(value="managementRouter")
    private Router nodeRouter;
    @Autowired
    @Qualifier(value="managementWebhookRouter")
    private Router nodeWebhookRouter;

    @Override
    public void register(ManagementEndpoint endpoint) {
        LOGGER.info("Register a new endpoint for Management API: {} {} [{}]", new Object[]{endpoint.method(), endpoint.path(), endpoint.getClass().getName()});
        if (endpoint.isWebhook()) {
            this.nodeWebhookRouter.route(this.convert(endpoint.method()), endpoint.path()).handler(endpoint::handle);
        } else {
            this.nodeRouter.route(this.convert(endpoint.method()), endpoint.path()).handler(endpoint::handle);
        }
    }

    private io.vertx.core.http.HttpMethod convert(HttpMethod httpMethod) {
        switch (httpMethod) {
            case CONNECT: {
                return io.vertx.core.http.HttpMethod.CONNECT;
            }
            case DELETE: {
                return io.vertx.core.http.HttpMethod.DELETE;
            }
            case GET: {
                return io.vertx.core.http.HttpMethod.GET;
            }
            case HEAD: {
                return io.vertx.core.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.vertx.core.http.HttpMethod.OPTIONS;
            }
            case PATCH: {
                return io.vertx.core.http.HttpMethod.PATCH;
            }
            case POST: {
                return io.vertx.core.http.HttpMethod.POST;
            }
            case PUT: {
                return io.vertx.core.http.HttpMethod.PUT;
            }
            case TRACE: {
                return io.vertx.core.http.HttpMethod.TRACE;
            }
            case OTHER: {
                return io.vertx.core.http.HttpMethod.valueOf((String)httpMethod.name());
            }
        }
        return null;
    }
}

