/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.license;

import io.gravitee.node.api.Node;
import io.gravitee.node.api.license.Feature;
import io.gravitee.node.api.license.License;
import io.gravitee.node.api.license.LicenseModelService;
import io.gravitee.node.api.license.NodeLicenseService;
import io.gravitee.node.api.license.model.LicenseModel;
import io.gravitee.node.api.license.model.LicensePack;
import io.gravitee.node.api.license.model.LicenseTier;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NodeLicenseServiceImpl
implements NodeLicenseService {
    private static final String LICENSE_TIER_KEY = "tier";
    private static final String LICENSE_PACKS_KEY = "packs";
    private static final String LICENSE_FEATURES_KEY = "features";
    private static final String LEGACY_FEATURE_VALUE = "included";
    private static final String LIST_SEPARATOR = ",";
    private final Node node;
    private final LicenseModelService licenseModelService;
    private String tier;
    private Set<String> packs = Set.of();
    private Set<String> features = Set.of();

    public NodeLicenseServiceImpl(Node node, LicenseModelService licenseModelService) {
        this.node = node;
        this.licenseModelService = licenseModelService;
    }

    public String getTier() {
        return this.tier;
    }

    public Set<String> getPacks() {
        return this.packs;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public boolean isFeatureEnabled(String featureName) {
        return featureName == null || this.features.contains(featureName);
    }

    public void refresh() {
        this.tier = this.readTier();
        this.packs = this.readPacks();
        this.features = this.readFeatures();
    }

    private String readTier() {
        return this.readString(LICENSE_TIER_KEY).orElse(null);
    }

    private Set<String> readPacks() {
        HashSet<String> licensePacks = new HashSet<String>(this.readList(LICENSE_PACKS_KEY));
        if (this.tier != null) {
            Set tierPacks = ((LicenseTier)this.licenseModelService.getLicenseModel().getTiers().get(this.tier)).getPacks();
            licensePacks.addAll(tierPacks);
        }
        return licensePacks;
    }

    private Set<String> readFeatures() {
        HashSet<String> licenseFeatures = new HashSet<String>();
        LicenseModel licenseModel = this.licenseModelService.getLicenseModel();
        licenseFeatures.addAll(this.readList(LICENSE_FEATURES_KEY));
        licenseFeatures.addAll(this.getLegacyFeatures());
        for (String pack : this.getPacks()) {
            licenseFeatures.addAll(((LicensePack)licenseModel.getPacks().get(pack)).getFeatures());
        }
        return licenseFeatures;
    }

    private Set<String> readList(String key) {
        return this.readString(key).map(value -> Set.of(value.split(LIST_SEPARATOR))).orElse(Set.of());
    }

    private Optional<String> readString(String featureKey) {
        return this.findLicense().flatMap(license -> license.feature(featureKey)).map(Feature::getString).filter(s -> !s.isBlank());
    }

    private Optional<License> findLicense() {
        return Optional.ofNullable(this.node.license());
    }

    private Set<String> getLegacyFeatures() {
        return this.findLicense().map(this::readLegacyFeatures).orElse(Set.of());
    }

    private Set<String> readLegacyFeatures(License license) {
        return license.features().entrySet().stream().filter(entry -> LEGACY_FEATURE_VALUE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

