/**
 * Copyright (C) 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.node.license.license3j;

import io.gravitee.node.api.license.Feature;
import java.time.Instant;

/**
 * @author David BRASSELY (david.brassely at graviteesource.com)
 * @author GraviteeSource Team
 */
public class License3JFeature implements Feature {

    private final javax0.license3j.Feature feature;

    public License3JFeature(javax0.license3j.Feature feature) {
        this.feature = feature;
    }

    @Override
    public String getString() {
        return feature.getString();
    }

    @Override
    public int getInt() {
        return feature.getInt();
    }

    @Override
    public Instant getDate() {
        return feature.getDate().toInstant();
    }
}
