/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container;

import io.gravitee.node.api.Node;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class NodeFactory
extends AbstractFactoryBean<Node>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Class<? extends Node> nodeClass;

    public NodeFactory(Class<? extends Node> nodeClass) {
        this.nodeClass = nodeClass;
    }

    public Class<?> getObjectType() {
        return Node.class;
    }

    protected Node createInstance() throws Exception {
        Node node = this.nodeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.autowire(node);
        return node;
    }

    private void autowire(Node node) throws Exception {
        if (node != null) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)node);
            if (node instanceof ApplicationContextAware) {
                ((ApplicationContextAware)node).setApplicationContext(this.applicationContext);
            }
            if (node instanceof InitializingBean) {
                ((InitializingBean)node).afterPropertiesSet();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

