/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugin.cluster.standalone.messaging;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.cluster.messaging.Message;
import io.gravitee.node.api.cluster.messaging.MessageListener;
import io.gravitee.node.api.cluster.messaging.Queue;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StandaloneQueue<T>
implements Queue<T> {
    private final Map<String, MessageConsumer<T>> consumerMap = new ConcurrentHashMap<String, MessageConsumer<T>>();
    private final Vertx vertx;
    private final String queueName;
    private final DeliveryOptions deliveryOptions;

    public StandaloneQueue(Vertx vertx, String queueName) {
        this.vertx = vertx;
        this.queueName = queueName;
        this.deliveryOptions = new DeliveryOptions().setCodecName("standalone-codec");
    }

    public void add(T item) {
        this.vertx.eventBus().send(this.queueName, item, this.deliveryOptions);
    }

    public String addMessageListener(MessageListener<T> messageListener) {
        String subscriptionId = UUID.random().toString();
        MessageConsumer vertxConsumer = this.vertx.eventBus().localConsumer(this.queueName).handler(event -> this.vertx.executeBlocking(promise -> {
            messageListener.onMessage(new Message(this.queueName, event.body()));
            promise.handle(null);
        }));
        this.consumerMap.put(subscriptionId, vertxConsumer);
        return subscriptionId;
    }

    public boolean removeMessageListener(String subscriptionId) {
        if (this.consumerMap.containsKey(subscriptionId)) {
            return this.consumerMap.get(subscriptionId).unregister().onSuccess(event -> this.consumerMap.remove(subscriptionId)).succeeded();
        }
        return false;
    }
}

