/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugin.cluster.standalone;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.cluster.Member;
import io.gravitee.node.api.cluster.MemberListener;
import io.gravitee.node.api.cluster.messaging.Queue;
import io.gravitee.node.api.cluster.messaging.Topic;
import io.gravitee.node.plugin.cluster.standalone.StandaloneMember;
import io.gravitee.node.plugin.cluster.standalone.messaging.StandaloneMessageCodec;
import io.gravitee.node.plugin.cluster.standalone.messaging.StandaloneQueue;
import io.gravitee.node.plugin.cluster.standalone.messaging.StandaloneTopic;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageCodec;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StandaloneClusterManager
extends AbstractService<ClusterManager>
implements ClusterManager {
    private static final Member LOCAL_MEMBER = new StandaloneMember();
    private final Map<String, Topic<?>> topicsByName = new ConcurrentHashMap();
    private final Map<String, Queue<?>> queuesByName = new ConcurrentHashMap();
    private final Vertx vertx;

    protected void doStart() throws Exception {
        super.doStart();
        this.vertx.eventBus().registerCodec((MessageCodec)new StandaloneMessageCodec());
    }

    public String clusterId() {
        return "standalone";
    }

    public Set<Member> members() {
        return Set.of(LOCAL_MEMBER);
    }

    public Member self() {
        return LOCAL_MEMBER;
    }

    public void addMemberListener(MemberListener listener) {
    }

    public void removeMemberListener(MemberListener listener) {
    }

    public <T> Topic<T> topic(String name) {
        return this.topicsByName.computeIfAbsent(name, key -> new StandaloneTopic(this.vertx, name));
    }

    public <T> Queue<T> queue(String name) {
        return this.queuesByName.computeIfAbsent(name, key -> new StandaloneQueue(this.vertx, name));
    }

    public StandaloneClusterManager(Vertx vertx) {
        this.vertx = vertx;
    }
}

