/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cluster;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.cluster.NoClusterManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class NodeClusterService
extends AbstractService<NodeClusterService> {
    private static final Logger log = LoggerFactory.getLogger(NodeClusterService.class);
    @Autowired
    private Node node;
    @Autowired
    @Lazy
    private ClusterManager clusterManager;

    public void doStart() throws Exception {
        super.doStart();
        this.node.metadata().put("node.id", this.node.id());
        this.node.metadata().put("node.hostname", this.node.hostname());
        try {
            this.clusterManager.start();
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("No Cluster manager has been registered.");
            throw new NoClusterManagerException();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
    }
}

