/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cache.standalone;

import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.api.cache.CacheListener;
import io.gravitee.node.api.cache.EntryEvent;
import io.gravitee.node.api.cache.EntryEventType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class StandaloneCache<K, V>
implements Cache<K, V> {
    private final String name;
    private final CacheConfiguration configuration;
    private final AtomicInteger counter = new AtomicInteger();
    private final com.google.common.cache.Cache<K, ValueWrapper<V>> internalCache;
    private final Set<CacheListener<K, V>> cacheListeners = new HashSet<CacheListener<K, V>>();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "gio-standalone-cache"));

    public StandaloneCache(String name, CacheConfiguration configuration) {
        this.name = name;
        this.configuration = configuration;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (configuration.getMaxSize() > 0L) {
            cacheBuilder.maximumSize(configuration.getMaxSize());
        }
        if (configuration.getTimeToIdleSeconds() > 0L) {
            cacheBuilder.expireAfterAccess(configuration.getTimeToIdleSeconds(), TimeUnit.SECONDS);
        }
        if (configuration.getTimeToLiveSeconds() > 0L) {
            cacheBuilder.expireAfterWrite(configuration.getTimeToLiveSeconds(), TimeUnit.SECONDS);
        }
        cacheBuilder.removalListener(notification -> this.counter.decrementAndGet());
        this.internalCache = cacheBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.counter.get();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<V> values() {
        return this.internalCache.asMap().values().stream().filter(e -> e.expirationTimeMillis == 0L || System.currentTimeMillis() <= e.expirationTimeMillis).map(vValueWrapper -> vValueWrapper.value).collect(Collectors.toList());
    }

    public V get(K key) {
        ValueWrapper vw = (ValueWrapper)this.internalCache.getIfPresent(key);
        if (vw != null && (vw.expirationTimeMillis == 0L || System.currentTimeMillis() <= vw.expirationTimeMillis)) {
            return (V)vw.value;
        }
        this.internalCache.invalidate(key);
        return null;
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    public V put(K key, V value, long ttl, TimeUnit ttlUnit) {
        if (this.configuration.getTimeToLiveSeconds() > 0L) {
            Verify.verify((TimeUnit.MILLISECONDS.convert(ttl, ttlUnit) <= TimeUnit.MILLISECONDS.convert(this.configuration.getTimeToLiveSeconds(), TimeUnit.SECONDS) ? 1 : 0) != 0, (String)"single ttl can't be bigger than ttl defined in the configuration", (Object[])new Object[0]);
        }
        V currentValue = this.get(key);
        long ttlMillis = TimeUnit.MILLISECONDS.convert(ttl, ttlUnit);
        long expirationTimeMillis = ttlMillis != 0L ? System.currentTimeMillis() + ttlMillis : 0L;
        this.counter.incrementAndGet();
        this.internalCache.put(key, new ValueWrapper<V>(value, expirationTimeMillis));
        executorService.execute(() -> {
            if (currentValue == null) {
                this.cacheListeners.forEach(listener -> new EntryEvent((Object)this.name, EntryEventType.ADDED, key, null, value));
            } else {
                this.cacheListeners.forEach(listener -> new EntryEvent((Object)this.name, EntryEventType.UPDATED, key, currentValue, value));
            }
        });
        return currentValue;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Map<Object, ValueWrapper> wrapperMap = m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ValueWrapper(e.getValue(), 0L)));
        this.counter.addAndGet(wrapperMap.size());
        this.internalCache.putAll(wrapperMap);
    }

    public V evict(K key) {
        V v = this.get(key);
        this.internalCache.invalidate(key);
        executorService.execute(() -> this.cacheListeners.forEach(cacheListener -> new EntryEvent((Object)this.name, EntryEventType.REMOVED, key, v, null)));
        return v;
    }

    public void clear() {
        this.internalCache.invalidateAll();
    }

    public void addCacheListener(CacheListener<K, V> listener) {
        this.cacheListeners.add(listener);
    }

    public boolean removeCacheListener(CacheListener<K, V> listener) {
        return this.cacheListeners.remove(listener);
    }

    private static class ValueWrapper<T> {
        private final T value;
        private final long expirationTimeMillis;

        public ValueWrapper(T value, long expirationTimeMillis) {
            this.value = value;
            this.expirationTimeMillis = expirationTimeMillis;
        }
    }
}

