/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cache.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.cache.hazelcast.HazelcastCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HazelcastCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final HazelcastInstance hazelcastInstance;

    public HazelcastCacheManager(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public <K, V> Cache<K, V> getOrCreateCache(String name) {
        return this.getOrCreateCache(name, new CacheConfiguration());
    }

    public <K, V> Cache<K, V> getOrCreateCache(String name, CacheConfiguration configuration) {
        return this.caches.computeIfAbsent(name, s -> {
            this.configureCache((String)s, configuration);
            return new HazelcastCache(this.hazelcastInstance.getMap(name), configuration);
        });
    }

    public void destroy(String name) {
        Cache cache = (Cache)this.caches.remove(name);
        if (cache != null) {
            cache.clear();
        }
    }

    private void configureCache(String name, CacheConfiguration configuration) {
        Config config = this.hazelcastInstance.getConfig();
        if (config != null && !config.getMapConfigs().containsKey(name)) {
            MapConfig resourceConfig = new MapConfig(name);
            resourceConfig.setAsyncBackupCount(0);
            resourceConfig.setBackupCount(0);
            if (configuration.getMaxSize() > 0L) {
                resourceConfig.getEvictionConfig().setSize((int)configuration.getMaxSize());
            }
            if (resourceConfig.getEvictionConfig().getEvictionPolicy().equals((Object)EvictionPolicy.NONE)) {
                resourceConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU);
            }
            if (configuration.getTimeToIdleSeconds() > 0L) {
                resourceConfig.setMaxIdleSeconds((int)configuration.getTimeToIdleSeconds());
            }
            if (configuration.getTimeToLiveSeconds() > 0L) {
                resourceConfig.setTimeToLiveSeconds((int)configuration.getTimeToLiveSeconds());
            }
            config.addMapConfig(resourceConfig);
        }
    }
}

