/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.secrets.util;

import io.gravitee.node.api.secrets.model.Secret;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigHelper {
    public static String getSecretAsString(Map<String, Object> propertiesMap, String propertyName, String defaultValue) {
        return ConfigHelper.secretAsStringOrCast(propertiesMap.getOrDefault(propertyName, defaultValue));
    }

    public static String getSecretAsString(Map<String, Object> propertiesMap, String propertyName) {
        Object data = Objects.requireNonNull(propertiesMap.get(propertyName));
        return ConfigHelper.secretAsStringOrCast(data);
    }

    private static String secretAsStringOrCast(Object data) {
        if (data instanceof Secret) {
            Secret secret = (Secret)data;
            return secret.asString();
        }
        return (String)data;
    }

    public static <T extends Enum<T>> T enumValueOfIgnoreCase(String literal, Class<T> enumClass, String propertyName) {
        EnumSet<Enum> values = EnumSet.allOf(enumClass);
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(literal)) continue;
            return (T)value;
        }
        throw new IllegalArgumentException("Invalid value for %s: %s. Possible values: '%s'".formatted(propertyName, literal, values.stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.joining("', '"))));
    }

    public static Map<String, Object> removePrefix(Map<String, Object> propertiesMap, String prefix) {
        return propertiesMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length() + 1), Map.Entry::getValue));
    }

    public static <T> T getProperty(Map<String, Object> map, String property, Class<T> type) {
        return ConfigHelper.getProperty(map, property, type, true);
    }

    public static <T> T getProperty(Map<String, Object> map, String property, Class<T> type, T defaultValue) {
        T val = ConfigHelper.getProperty(map, property, type, false);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    private static <T> T getProperty(Map<String, Object> map, String property, Class<T> type, boolean failOnNull) {
        Objects.requireNonNull(map);
        Object value = map.get(property);
        if (failOnNull) {
            Objects.requireNonNull(value, "property '%s' must not be null".formatted(property));
        } else if (value == null) {
            return null;
        }
        if (value.getClass().equals(type)) {
            return (T)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            switch (type.getName()) {
                case "java.lang.Boolean": {
                    return (T)Boolean.valueOf(str);
                }
                case "java.lang.Integer": {
                    return (T)Integer.valueOf(str);
                }
                case "java.lang.Long": {
                    return (T)Long.valueOf(str);
                }
            }
            throw new IllegalArgumentException("Cannot convert property '%s' to type: %s".formatted(property, type.getName()));
        }
        throw new IllegalArgumentException("Cannot convert property '%s' of type: %s".formatted(property, value.getClass().getName()));
    }

    private ConfigHelper() {
    }
}

