/**
 * Copyright (C) 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.node.api.notifier;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;

/**
 * @author Eric LELEU (eric.leleu at graviteesource.com)
 * @author GraviteeSource Team
 */
public interface NotificationAcknowledgeRepository {
    Maybe<NotificationAcknowledge> findById(String id);

    Maybe<NotificationAcknowledge> findByResourceIdAndTypeAndAudienceId(
        String resourceId,
        String resourceType,
        String type,
        String audienceId
    );

    Single<NotificationAcknowledge> create(NotificationAcknowledge notificationAcknowledge);

    Single<NotificationAcknowledge> update(NotificationAcknowledge notificationAcknowledge);

    Completable deleteByResourceId(String resourceId, String resourceType);
}
