/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.maven.plugins.json.schema.generator.util;

import io.gravitee.maven.plugins.json.schema.generator.util.ClassUtils;
import io.gravitee.maven.plugins.json.schema.generator.util.Globs;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class ClassFinder {
    private static final String CLASS_EXTENSION = ".class";

    public static List<String> findClassNames(Path root, Globs globs) throws IOException {
        Validate.notNull((Object)root, (String)"Unable to handle null root path", (Object[])new Object[0]);
        Validate.isTrue((boolean)root.toFile().isDirectory(), (String)"Unable to handle non existing or non directory root path", (Object[])new Object[0]);
        Validate.notNull((Object)globs, (String)"Unable to handle null globs", (Object[])new Object[0]);
        ArrayList<String> matchedClassNames = new ArrayList<String>();
        matchedClassNames.addAll(ClassFinder.findClassPaths(root, globs).stream().map(path -> ClassUtils.convertClassPathToClassName(path.toString(), root.normalize().toString())).collect(Collectors.toList()));
        return matchedClassNames;
    }

    private static List<Path> findClassPaths(Path root, Globs globs) throws IOException {
        ArrayList<Path> matchedPaths = new ArrayList<Path>();
        Files.walkFileTree(root.normalize(), new GlobsMatchingClassFileVisitor(globs, matchedPaths));
        return matchedPaths;
    }

    private static class GlobsMatchingClassFileVisitor
    extends SimpleFileVisitor<Path> {
        private final GlobPathMatchers globPathMatchers;
        private final List<Path> matchedPaths;

        public GlobsMatchingClassFileVisitor(Globs globs, List<Path> matchedPaths) {
            this.globPathMatchers = new GlobPathMatchers(globs);
            this.matchedPaths = matchedPaths;
        }

        private static String formatGlob(String glob) {
            glob = "**/" + glob;
            return glob;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes fileAttributes) {
            if (!path.getFileName().toString().endsWith(ClassFinder.CLASS_EXTENSION)) {
                return FileVisitResult.CONTINUE;
            }
            for (PathMatcher excludedMatcher : this.globPathMatchers.getExcludedMatchers()) {
                if (!excludedMatcher.matches(path)) continue;
                return FileVisitResult.CONTINUE;
            }
            if (this.globPathMatchers.getIncludedMatchers().isEmpty()) {
                this.matchedPaths.add(path);
                return FileVisitResult.CONTINUE;
            }
            for (PathMatcher includedMatcher : this.globPathMatchers.getIncludedMatchers()) {
                if (!includedMatcher.matches(path)) continue;
                this.matchedPaths.add(path);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        private static class GlobPathMatchers {
            private final List<PathMatcher> includedMatchers = new ArrayList<PathMatcher>();
            private final List<PathMatcher> excludedMatchers;

            public GlobPathMatchers(Globs globs) {
                this.includedMatchers.addAll(globs.getIncludes().stream().map(include -> FileSystems.getDefault().getPathMatcher("glob:" + GlobsMatchingClassFileVisitor.formatGlob(include))).collect(Collectors.toList()));
                this.excludedMatchers = new ArrayList<PathMatcher>();
                this.excludedMatchers.addAll(globs.getExcludes().stream().map(exclude -> FileSystems.getDefault().getPathMatcher("glob:" + GlobsMatchingClassFileVisitor.formatGlob(exclude))).collect(Collectors.toList()));
            }

            public List<PathMatcher> getIncludedMatchers() {
                return this.includedMatchers;
            }

            public List<PathMatcher> getExcludedMatchers() {
                return this.excludedMatchers;
            }
        }
    }
}

