/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.maven.plugins.json.schema.generator.mojo;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import io.gravitee.maven.plugins.json.schema.generator.mojo.Config;
import io.gravitee.maven.plugins.json.schema.generator.mojo.VisitorContext;
import io.gravitee.maven.plugins.json.schema.generator.util.ClassFinder;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class Mapper {
    private Config config;

    public Mapper(Config config) {
        this.config = config;
    }

    public List<JsonSchema> generateJsonSchemas() {
        ArrayList<JsonSchema> generatedSchemas = new ArrayList<JsonSchema>();
        ObjectMapper mapper = new ObjectMapper();
        SchemaFactoryWrapper schemaVisitor = new SchemaFactoryWrapper();
        schemaVisitor.setVisitorContext((com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext)new VisitorContext());
        for (String className : this.generateClassNames()) {
            try {
                try {
                    mapper.acceptJsonFormatVisitor(mapper.constructType(this.getClass().getClassLoader().loadClass(className)), (JsonFormatVisitorWrapper)schemaVisitor);
                }
                catch (JsonMappingException e) {
                    throw new GenerationException("Unable to format class " + className, e);
                }
                JsonSchema schema = schemaVisitor.finalSchema();
                if (schema == null) {
                    throw new IllegalArgumentException("Could not build schema or find any classes.");
                }
                generatedSchemas.add(schema);
            }
            catch (GenerationException | ClassNotFoundException e) {
                this.config.getLogger().warn((CharSequence)("Unable to generate JSON schema for class " + className), (Throwable)e);
            }
        }
        return generatedSchemas;
    }

    private List<String> generateClassNames() {
        HashSet<String> classNames = new HashSet<String>();
        Path root = Paths.get(this.config.getBuildDirectory(), new String[0]);
        if (!root.toFile().isDirectory()) {
            this.config.getLogger().error((CharSequence)("Invalid underlying project build directory: " + this.config.getBuildDirectory()));
            return Collections.emptyList();
        }
        try {
            classNames.addAll(ClassFinder.findClassNames(root, this.config.getGlobs()));
            this.config.getLogger().debug((CharSequence)("Generated class names: " + classNames));
        }
        catch (IOException e) {
            this.config.getLogger().warn((CharSequence)"Unable to generate JSON schemas", (Throwable)e);
        }
        return new ArrayList<String>(classNames);
    }

    private static class GenerationException
    extends Exception {
        public GenerationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

