/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.message;

import io.gravitee.common.util.ListUtils;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.message.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultMessage
implements Message {
    public static final String SOURCE_TIMESTAMP = "sourceTimestamp";
    private String id;
    private String correlationId;
    private String parentCorrelationId;
    private long timestamp;
    private long sourceTimestamp;
    private Map<String, Object> attributes;
    private Map<String, Object> internalAttributes;
    private Map<String, Object> metadata;
    private HttpHeaders headers;
    private Buffer content;
    private boolean error;
    private Runnable ackRunnable;

    public DefaultMessage(String content) {
        this();
        if (content != null) {
            this.content = Buffer.buffer(content);
        }
    }

    private static Map<String, Object> unmodifiableMetadata(Map<String, Object> metadata) {
        if (metadata != null) {
            return Collections.unmodifiableMap(metadata);
        }
        return Map.of();
    }

    @Override
    public <T> T attribute(String name) {
        return (T)this.getOrInitAttribute().get(name);
    }

    @Override
    public <T> List<T> attributeAsList(String name) {
        return ListUtils.toList((Object)this.getOrInitAttribute().get(name));
    }

    @Override
    public DefaultMessage attribute(String name, Object value) {
        this.getOrInitAttribute().put(name, value);
        return this;
    }

    @Override
    public DefaultMessage removeAttribute(String name) {
        this.getOrInitAttribute().remove(name);
        return this;
    }

    @Override
    public Set<String> attributeNames() {
        return this.getOrInitAttribute().keySet();
    }

    @Override
    public <T> Map<String, T> attributes() {
        return Collections.unmodifiableMap(this.getOrInitAttribute());
    }

    @Override
    public <T> T internalAttribute(String name) {
        return (T)this.getOrInitInternalAttribute().get(name);
    }

    @Override
    public DefaultMessage internalAttribute(String name, Object value) {
        this.getOrInitInternalAttribute().put(name, value);
        return this;
    }

    @Override
    public DefaultMessage removeInternalAttribute(String name) {
        this.getOrInitInternalAttribute().remove(name);
        return this;
    }

    @Override
    public Set<String> internalAttributeNames() {
        return this.getOrInitInternalAttribute().keySet();
    }

    @Override
    public <T> Map<String, T> internalAttributes() {
        return Collections.unmodifiableMap(this.getOrInitInternalAttribute());
    }

    @Override
    public Map<String, Object> metadata() {
        if (this.metadata == null) {
            this.metadata = Map.of();
        }
        return this.metadata;
    }

    @Override
    public HttpHeaders headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.create();
        }
        return this.headers;
    }

    @Override
    public DefaultMessage content(Buffer content) {
        this.content = content;
        return this;
    }

    @Override
    public DefaultMessage content(String content) {
        if (content != null) {
            this.content(Buffer.buffer(content));
        } else {
            this.content((Buffer)null);
        }
        return this;
    }

    public DefaultMessage metadata(Map<String, Object> metadata) {
        this.metadata = DefaultMessage.unmodifiableMetadata(metadata);
        return this;
    }

    @Override
    public void ack() {
        if (this.ackRunnable != null) {
            this.ackRunnable.run();
        }
    }

    public static DefaultMessageBuilder builder() {
        return new DefaultMessageBuilder(){

            @Override
            public DefaultMessage build() {
                this.prebuild();
                return super.build();
            }
        };
    }

    private Map<String, Object> getOrInitAttribute() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    private Map<String, Object> getOrInitInternalAttribute() {
        if (this.internalAttributes == null) {
            this.internalAttributes = new HashMap<String, Object>();
        }
        return this.internalAttributes;
    }

    private static String $default$correlationId() {
        return UUID.randomUUID().toString();
    }

    private static long $default$timestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    public String parentCorrelationId() {
        return this.parentCorrelationId;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public Buffer content() {
        return this.content;
    }

    @Override
    public boolean error() {
        return this.error;
    }

    public Runnable ackRunnable() {
        return this.ackRunnable;
    }

    public DefaultMessage id(String id) {
        this.id = id;
        return this;
    }

    public DefaultMessage correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public DefaultMessage parentCorrelationId(String parentCorrelationId) {
        this.parentCorrelationId = parentCorrelationId;
        return this;
    }

    public DefaultMessage timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public DefaultMessage attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public DefaultMessage internalAttributes(Map<String, Object> internalAttributes) {
        this.internalAttributes = internalAttributes;
        return this;
    }

    @Override
    public DefaultMessage headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public DefaultMessage error(boolean error) {
        this.error = error;
        return this;
    }

    public DefaultMessage ackRunnable(Runnable ackRunnable) {
        this.ackRunnable = ackRunnable;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.timestamp() != other.timestamp()) {
            return false;
        }
        if (this.sourceTimestamp != other.sourceTimestamp) {
            return false;
        }
        if (this.error() != other.error()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$correlationId = this.correlationId();
        String other$correlationId = other.correlationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$parentCorrelationId = this.parentCorrelationId();
        String other$parentCorrelationId = other.parentCorrelationId();
        if (this$parentCorrelationId == null ? other$parentCorrelationId != null : !this$parentCorrelationId.equals(other$parentCorrelationId)) {
            return false;
        }
        Map this$attributes = this.attributes();
        Map other$attributes = other.attributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map this$internalAttributes = this.internalAttributes();
        Map other$internalAttributes = other.internalAttributes();
        if (this$internalAttributes == null ? other$internalAttributes != null : !((Object)this$internalAttributes).equals(other$internalAttributes)) {
            return false;
        }
        Map<String, Object> this$metadata = this.metadata();
        Map<String, Object> other$metadata = other.metadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Buffer this$content = this.content();
        Buffer other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Runnable this$ackRunnable = this.ackRunnable();
        Runnable other$ackRunnable = other.ackRunnable();
        return !(this$ackRunnable == null ? other$ackRunnable != null : !this$ackRunnable.equals(other$ackRunnable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.timestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $sourceTimestamp = this.sourceTimestamp;
        result = result * 59 + (int)($sourceTimestamp >>> 32 ^ $sourceTimestamp);
        result = result * 59 + (this.error() ? 79 : 97);
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $correlationId = this.correlationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $parentCorrelationId = this.parentCorrelationId();
        result = result * 59 + ($parentCorrelationId == null ? 43 : $parentCorrelationId.hashCode());
        Map $attributes = this.attributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map $internalAttributes = this.internalAttributes();
        result = result * 59 + ($internalAttributes == null ? 43 : ((Object)$internalAttributes).hashCode());
        Map<String, Object> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Buffer $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Runnable $ackRunnable = this.ackRunnable();
        result = result * 59 + ($ackRunnable == null ? 43 : $ackRunnable.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultMessage(id=" + this.id() + ", correlationId=" + this.correlationId() + ", parentCorrelationId=" + this.parentCorrelationId() + ", timestamp=" + this.timestamp() + ", sourceTimestamp=" + this.sourceTimestamp + ", attributes=" + this.attributes() + ", internalAttributes=" + this.internalAttributes() + ", metadata=" + this.metadata() + ", headers=" + this.headers() + ", content=" + this.content() + ", error=" + this.error() + ", ackRunnable=" + this.ackRunnable() + ")";
    }

    public DefaultMessage(String id, String correlationId, String parentCorrelationId, long timestamp, long sourceTimestamp, Map<String, Object> attributes, Map<String, Object> internalAttributes, Map<String, Object> metadata, HttpHeaders headers, Buffer content, boolean error, Runnable ackRunnable) {
        this.sourceTimestamp = this.timestamp;
        this.id = id;
        this.correlationId = correlationId;
        this.parentCorrelationId = parentCorrelationId;
        this.timestamp = timestamp;
        this.sourceTimestamp = sourceTimestamp;
        this.attributes = attributes;
        this.internalAttributes = internalAttributes;
        this.metadata = metadata;
        this.headers = headers;
        this.content = content;
        this.error = error;
        this.ackRunnable = ackRunnable;
    }

    public DefaultMessage() {
        this.sourceTimestamp = this.timestamp;
        this.correlationId = DefaultMessage.$default$correlationId();
        this.timestamp = DefaultMessage.$default$timestamp();
    }

    public static class DefaultMessageBuilder {
        private String id;
        private boolean correlationId$set;
        private String correlationId$value;
        private String parentCorrelationId;
        private boolean timestamp$set;
        private long timestamp$value;
        private long sourceTimestamp;
        private Map<String, Object> attributes;
        private Map<String, Object> internalAttributes;
        private Map<String, Object> metadata;
        private HttpHeaders headers;
        private Buffer content;
        private boolean error;
        private Runnable ackRunnable;

        void prebuild() {
            if (!this.timestamp$set) {
                this.timestamp(System.currentTimeMillis());
            }
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Object>();
            }
            if (!this.metadata.containsKey(DefaultMessage.SOURCE_TIMESTAMP)) {
                this.metadata.put(DefaultMessage.SOURCE_TIMESTAMP, this.sourceTimestamp != 0L ? this.sourceTimestamp : this.timestamp$value);
            }
            this.metadata = DefaultMessage.unmodifiableMetadata(this.metadata);
        }

        DefaultMessageBuilder() {
        }

        public DefaultMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DefaultMessageBuilder correlationId(String correlationId) {
            this.correlationId$value = correlationId;
            this.correlationId$set = true;
            return this;
        }

        public DefaultMessageBuilder parentCorrelationId(String parentCorrelationId) {
            this.parentCorrelationId = parentCorrelationId;
            return this;
        }

        public DefaultMessageBuilder timestamp(long timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        public DefaultMessageBuilder sourceTimestamp(long sourceTimestamp) {
            this.sourceTimestamp = sourceTimestamp;
            return this;
        }

        public DefaultMessageBuilder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public DefaultMessageBuilder internalAttributes(Map<String, Object> internalAttributes) {
            this.internalAttributes = internalAttributes;
            return this;
        }

        public DefaultMessageBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public DefaultMessageBuilder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public DefaultMessageBuilder content(Buffer content) {
            this.content = content;
            return this;
        }

        public DefaultMessageBuilder error(boolean error) {
            this.error = error;
            return this;
        }

        public DefaultMessageBuilder ackRunnable(Runnable ackRunnable) {
            this.ackRunnable = ackRunnable;
            return this;
        }

        public DefaultMessage build() {
            String correlationId$value = this.correlationId$value;
            if (!this.correlationId$set) {
                correlationId$value = DefaultMessage.$default$correlationId();
            }
            long timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = DefaultMessage.$default$timestamp();
            }
            return new DefaultMessage(this.id, correlationId$value, this.parentCorrelationId, timestamp$value, this.sourceTimestamp, this.attributes, this.internalAttributes, this.metadata, this.headers, this.content, this.error, this.ackRunnable);
        }

        public String toString() {
            return "DefaultMessage.DefaultMessageBuilder(id=" + this.id + ", correlationId$value=" + this.correlationId$value + ", parentCorrelationId=" + this.parentCorrelationId + ", timestamp$value=" + this.timestamp$value + ", sourceTimestamp=" + this.sourceTimestamp + ", attributes=" + this.attributes + ", internalAttributes=" + this.internalAttributes + ", metadata=" + this.metadata + ", headers=" + this.headers + ", content=" + this.content + ", error=" + this.error + ", ackRunnable=" + this.ackRunnable + ")";
        }
    }
}

