/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;

public enum ConnectorMode {
    SUBSCRIBE("subscribe"),
    PUBLISH("publish"),
    REQUEST_RESPONSE("request_response");

    private static final Map<String, ConnectorMode> LABELS_MAP;
    @JsonValue
    private final String label;

    public static ConnectorMode fromLabel(String label) {
        if (label != null) {
            return LABELS_MAP.get(label);
        }
        return null;
    }

    private ConnectorMode(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        LABELS_MAP = Map.of(ConnectorMode.SUBSCRIBE.label, SUBSCRIBE, ConnectorMode.PUBLISH.label, PUBLISH, ConnectorMode.REQUEST_RESPONSE.label, REQUEST_RESPONSE);
    }
}

