/*
 * Copyright © 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.gateway.api.buffer;

import io.netty.buffer.ByteBuf;

/**
 * @author David BRASSELY (david at gravitee.io)
 * @author GraviteeSource Team
 */
public interface BufferFactory {
    Buffer buffer(ByteBuf nativeBuffer);

    Buffer buffer(io.vertx.core.buffer.Buffer vertxBuffer);

    Buffer buffer(io.vertx.rxjava3.core.buffer.Buffer vertxBuffer);

    Buffer buffer(int initialSizeHint);

    Buffer buffer();

    Buffer buffer(String str);

    Buffer buffer(String str, String enc);

    Buffer buffer(byte[] bytes);
}
