/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.service;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;

public class SubscriptionConfiguration {
    private String channel;
    private String entrypointId;
    @JsonRawValue
    private String entrypointConfiguration;

    @JsonSetter
    public void setEntrypointConfiguration(JsonNode configuration) {
        if (configuration != null) {
            this.entrypointConfiguration = configuration.toString();
        }
    }

    public void setEntrypointConfiguration(String configuration) {
        this.entrypointConfiguration = configuration;
    }

    public static SubscriptionConfigurationBuilder builder() {
        return new SubscriptionConfigurationBuilder();
    }

    public SubscriptionConfiguration() {
    }

    public SubscriptionConfiguration(String channel, String entrypointId, String entrypointConfiguration) {
        this.channel = channel;
        this.entrypointId = entrypointId;
        this.entrypointConfiguration = entrypointConfiguration;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getEntrypointId() {
        return this.entrypointId;
    }

    public String getEntrypointConfiguration() {
        return this.entrypointConfiguration;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setEntrypointId(String entrypointId) {
        this.entrypointId = entrypointId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionConfiguration)) {
            return false;
        }
        SubscriptionConfiguration other = (SubscriptionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$entrypointId = this.getEntrypointId();
        String other$entrypointId = other.getEntrypointId();
        if (this$entrypointId == null ? other$entrypointId != null : !this$entrypointId.equals(other$entrypointId)) {
            return false;
        }
        String this$entrypointConfiguration = this.getEntrypointConfiguration();
        String other$entrypointConfiguration = other.getEntrypointConfiguration();
        return !(this$entrypointConfiguration == null ? other$entrypointConfiguration != null : !this$entrypointConfiguration.equals(other$entrypointConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $entrypointId = this.getEntrypointId();
        result = result * 59 + ($entrypointId == null ? 43 : $entrypointId.hashCode());
        String $entrypointConfiguration = this.getEntrypointConfiguration();
        result = result * 59 + ($entrypointConfiguration == null ? 43 : $entrypointConfiguration.hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionConfiguration(channel=" + this.getChannel() + ", entrypointId=" + this.getEntrypointId() + ", entrypointConfiguration=" + this.getEntrypointConfiguration() + ")";
    }

    public static class SubscriptionConfigurationBuilder {
        private String channel;
        private String entrypointId;
        private String entrypointConfiguration;

        SubscriptionConfigurationBuilder() {
        }

        public SubscriptionConfigurationBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public SubscriptionConfigurationBuilder entrypointId(String entrypointId) {
            this.entrypointId = entrypointId;
            return this;
        }

        public SubscriptionConfigurationBuilder entrypointConfiguration(String entrypointConfiguration) {
            this.entrypointConfiguration = entrypointConfiguration;
            return this;
        }

        public SubscriptionConfiguration build() {
            return new SubscriptionConfiguration(this.channel, this.entrypointId, this.entrypointConfiguration);
        }

        public String toString() {
            return "SubscriptionConfiguration.SubscriptionConfigurationBuilder(channel=" + this.channel + ", entrypointId=" + this.entrypointId + ", entrypointConfiguration=" + this.entrypointConfiguration + ")";
        }
    }
}

