/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.service;

import io.gravitee.gateway.api.service.SubscriptionConfiguration;
import java.util.Date;
import java.util.Map;

public class Subscription {
    private String id;
    private String api;
    private String plan;
    private String application;
    private String clientId;
    private String status;
    private ConsumerStatus consumerStatus;
    private Date startingAt;
    private Date endingAt;
    private SubscriptionConfiguration configuration;
    private Map<String, String> metadata;
    private Type type;
    private boolean forceDispatch;

    public boolean isTimeValid(long requestTimestamp) {
        Date requestDate = new Date(requestTimestamp);
        return !(this.endingAt != null && !this.endingAt.after(requestDate) || this.startingAt != null && !this.startingAt.before(requestDate));
    }

    private static ConsumerStatus $default$consumerStatus() {
        return ConsumerStatus.STARTED;
    }

    private static Type $default$type() {
        return Type.STANDARD;
    }

    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    public Subscription() {
        this.consumerStatus = Subscription.$default$consumerStatus();
        this.type = Subscription.$default$type();
    }

    public Subscription(String id, String api, String plan, String application, String clientId, String status, ConsumerStatus consumerStatus, Date startingAt, Date endingAt, SubscriptionConfiguration configuration, Map<String, String> metadata, Type type, boolean forceDispatch) {
        this.id = id;
        this.api = api;
        this.plan = plan;
        this.application = application;
        this.clientId = clientId;
        this.status = status;
        this.consumerStatus = consumerStatus;
        this.startingAt = startingAt;
        this.endingAt = endingAt;
        this.configuration = configuration;
        this.metadata = metadata;
        this.type = type;
        this.forceDispatch = forceDispatch;
    }

    public String getId() {
        return this.id;
    }

    public String getApi() {
        return this.api;
    }

    public String getPlan() {
        return this.plan;
    }

    public String getApplication() {
        return this.application;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getStatus() {
        return this.status;
    }

    public ConsumerStatus getConsumerStatus() {
        return this.consumerStatus;
    }

    public Date getStartingAt() {
        return this.startingAt;
    }

    public Date getEndingAt() {
        return this.endingAt;
    }

    public SubscriptionConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isForceDispatch() {
        return this.forceDispatch;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setConsumerStatus(ConsumerStatus consumerStatus) {
        this.consumerStatus = consumerStatus;
    }

    public void setStartingAt(Date startingAt) {
        this.startingAt = startingAt;
    }

    public void setEndingAt(Date endingAt) {
        this.endingAt = endingAt;
    }

    public void setConfiguration(SubscriptionConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setForceDispatch(boolean forceDispatch) {
        this.forceDispatch = forceDispatch;
    }

    public String toString() {
        return "Subscription(id=" + this.getId() + ", api=" + this.getApi() + ", plan=" + this.getPlan() + ", application=" + this.getApplication() + ", clientId=" + this.getClientId() + ", status=" + this.getStatus() + ", consumerStatus=" + this.getConsumerStatus() + ", startingAt=" + this.getStartingAt() + ", endingAt=" + this.getEndingAt() + ", configuration=" + this.getConfiguration() + ", metadata=" + this.getMetadata() + ", type=" + this.getType() + ", forceDispatch=" + this.isForceDispatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$plan = this.getPlan();
        String other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ConsumerStatus this$consumerStatus = this.getConsumerStatus();
        ConsumerStatus other$consumerStatus = other.getConsumerStatus();
        if (this$consumerStatus == null ? other$consumerStatus != null : !((Object)((Object)this$consumerStatus)).equals((Object)other$consumerStatus)) {
            return false;
        }
        Date this$startingAt = this.getStartingAt();
        Date other$startingAt = other.getStartingAt();
        if (this$startingAt == null ? other$startingAt != null : !((Object)this$startingAt).equals(other$startingAt)) {
            return false;
        }
        Date this$endingAt = this.getEndingAt();
        Date other$endingAt = other.getEndingAt();
        if (this$endingAt == null ? other$endingAt != null : !((Object)this$endingAt).equals(other$endingAt)) {
            return false;
        }
        SubscriptionConfiguration this$configuration = this.getConfiguration();
        SubscriptionConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ConsumerStatus $consumerStatus = this.getConsumerStatus();
        result = result * 59 + ($consumerStatus == null ? 43 : ((Object)((Object)$consumerStatus)).hashCode());
        Date $startingAt = this.getStartingAt();
        result = result * 59 + ($startingAt == null ? 43 : ((Object)$startingAt).hashCode());
        Date $endingAt = this.getEndingAt();
        result = result * 59 + ($endingAt == null ? 43 : ((Object)$endingAt).hashCode());
        SubscriptionConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum ConsumerStatus {
        STOPPED,
        STARTED,
        FAILURE;

    }

    public static enum Type {
        STANDARD,
        PUSH;

    }

    public static class SubscriptionBuilder {
        private String id;
        private String api;
        private String plan;
        private String application;
        private String clientId;
        private String status;
        private boolean consumerStatus$set;
        private ConsumerStatus consumerStatus$value;
        private Date startingAt;
        private Date endingAt;
        private SubscriptionConfiguration configuration;
        private Map<String, String> metadata;
        private boolean type$set;
        private Type type$value;
        private boolean forceDispatch;

        SubscriptionBuilder() {
        }

        public SubscriptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SubscriptionBuilder api(String api) {
            this.api = api;
            return this;
        }

        public SubscriptionBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public SubscriptionBuilder application(String application) {
            this.application = application;
            return this;
        }

        public SubscriptionBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SubscriptionBuilder status(String status) {
            this.status = status;
            return this;
        }

        public SubscriptionBuilder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus$value = consumerStatus;
            this.consumerStatus$set = true;
            return this;
        }

        public SubscriptionBuilder startingAt(Date startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        public SubscriptionBuilder endingAt(Date endingAt) {
            this.endingAt = endingAt;
            return this;
        }

        public SubscriptionBuilder configuration(SubscriptionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public SubscriptionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public SubscriptionBuilder forceDispatch(boolean forceDispatch) {
            this.forceDispatch = forceDispatch;
            return this;
        }

        public Subscription build() {
            ConsumerStatus consumerStatus$value = this.consumerStatus$value;
            if (!this.consumerStatus$set) {
                consumerStatus$value = Subscription.$default$consumerStatus();
            }
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = Subscription.$default$type();
            }
            return new Subscription(this.id, this.api, this.plan, this.application, this.clientId, this.status, consumerStatus$value, this.startingAt, this.endingAt, this.configuration, this.metadata, type$value, this.forceDispatch);
        }

        public String toString() {
            return "Subscription.SubscriptionBuilder(id=" + this.id + ", api=" + this.api + ", plan=" + this.plan + ", application=" + this.application + ", clientId=" + this.clientId + ", status=" + this.status + ", consumerStatus$value=" + this.consumerStatus$value + ", startingAt=" + this.startingAt + ", endingAt=" + this.endingAt + ", configuration=" + this.configuration + ", metadata=" + this.metadata + ", type$value=" + this.type$value + ", forceDispatch=" + this.forceDispatch + ")";
        }
    }
}

