/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.proxy.ws;

import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.builder.ProxyRequestImpl;
import io.gravitee.gateway.api.proxy.ws.WebSocketProxyRequest;
import io.gravitee.gateway.api.ws.WebSocket;
import io.gravitee.gateway.api.ws.WebSocketFrame;
import java.util.concurrent.CompletableFuture;

public class WebSocketProxyRequestImpl
extends ProxyRequestImpl
implements WebSocketProxyRequest {
    private final WebSocket websocket;

    public WebSocketProxyRequestImpl(Request request) {
        super(request);
        this.websocket = request.websocket();
    }

    @Override
    public CompletableFuture<WebSocketProxyRequest> upgrade() {
        return this.websocket.upgrade().thenApply(webSocket -> this);
    }

    @Override
    public WebSocketProxyRequest reject(int statusCode) {
        this.websocket.reject(statusCode);
        return this;
    }

    @Override
    public WebSocketProxyRequest write(WebSocketFrame frame) {
        this.websocket.write(frame);
        return this;
    }

    @Override
    public WebSocketProxyRequest close() {
        this.websocket.close();
        return this;
    }

    @Override
    public WebSocketProxyRequest frameHandler(Handler<WebSocketFrame> handler) {
        this.websocket.frameHandler(handler);
        return this;
    }

    @Override
    public WebSocketProxyRequest closeHandler(Handler<Void> handler) {
        this.websocket.closeHandler(handler);
        return this;
    }
}

