/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http;

import io.gravitee.common.util.LinkedCaseInsensitiveMap;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.http.HttpHeaders;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
implements HttpHeaders,
MultiValueMap<String, String> {
    private final Map<String, List<String>> headers;

    DefaultHttpHeaders() {
        this.headers = new LinkedCaseInsensitiveMap(8);
    }

    private DefaultHttpHeaders(int initialCapacity) {
        this.headers = new LinkedCaseInsensitiveMap(initialCapacity);
    }

    DefaultHttpHeaders(HttpHeaders headers) {
        this(headers.size());
        headers.toListValuesMap().forEach((? super K key, ? super V values) -> values.forEach(value -> this.add((String)key, (String)value)));
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public String get(CharSequence name) {
        List<String> headerValues = this.headers.get(name.toString());
        return headerValues != null ? headerValues.get(0) : null;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.get(name.toString());
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.containsKey(name.toString());
    }

    @Override
    public Set<String> names() {
        return this.headers.keySet();
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence value) {
        List headerValues = this.headers.computeIfAbsent(name.toString(), s -> new LinkedList());
        headerValues.add(value.toString());
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<CharSequence> values) {
        if (values != null) {
            LinkedList list = new LinkedList();
            values.forEach(charSequence -> list.add(charSequence.toString()));
            this.headers.put(name.toString(), list);
        }
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence value) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(value.toString());
        this.headers.put(name.toString(), headerValues);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<CharSequence> values) {
        if (values != null) {
            LinkedList list = new LinkedList();
            values.forEach(charSequence -> list.add(charSequence.toString()));
            this.headers.put(name.toString(), list);
        }
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name) {
        this.headers.remove(name.toString());
        return this;
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    public boolean equals(Object o) {
        return this.headers.equals(o);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator<Map.Entry<String, List<String>>> entries = this.headers.entrySet().iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry next = (Map.Entry)entries.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return (String)next.getKey();
                    }

                    @Override
                    public String getValue() {
                        return (String)((List)next.getValue()).get(0);
                    }

                    @Override
                    public String setValue(String value) {
                        throw new IllegalStateException();
                    }
                };
            }
        };
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        return HttpHeaders.super.toSingleValueMap();
    }

    @Override
    public boolean containsAllKeys(Collection<String> names) {
        return HttpHeaders.super.containsAllKeys(names);
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key.toString());
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    public List<String> get(Object key) {
        return this.headers.get(key.toString());
    }

    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    public List<String> remove(Object key) {
        return this.headers.remove(key.toString());
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.headers.putAll(map);
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public String getFirst(String header) {
        List<String> headerValues = this.headers.get(header);
        return headerValues != null ? headerValues.get(0) : null;
    }

    public void add(String name, String value) {
        List headerValues = this.headers.computeIfAbsent(name, s -> new LinkedList());
        headerValues.add(value);
    }

    public void set(String name, String value) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(value);
        this.headers.put(name, headerValues);
    }

    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }
}

