/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.qos;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;

public enum QosCapability {
    MANUAL_ACK("manual-ack"),
    AUTO_ACK("auto-ack"),
    RECOVER("recover");

    private static final Map<String, QosCapability> maps;
    @JsonValue
    private final String label;

    public static QosCapability fromLabel(String label) {
        if (label != null) {
            return maps.get(label);
        }
        return null;
    }

    private QosCapability(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        maps = Map.of(QosCapability.MANUAL_ACK.label, MANUAL_ACK, QosCapability.AUTO_ACK.label, AUTO_ACK, QosCapability.RECOVER.label, RECOVER);
    }
}

