/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.api.policy;

public class SecurityToken {
    private String tokenType;
    private String tokenValue;

    public SecurityToken(String tokenType, String tokenValue) {
        this.tokenType = tokenType;
        this.tokenValue = tokenValue;
    }

    public SecurityToken(TokenType tokenType, String tokenValue) {
        this(tokenType.name(), tokenValue);
    }

    public static SecurityToken none() {
        return new SecurityToken(TokenType.NONE, null);
    }

    public static SecurityToken forApiKey(String apiKey) {
        return new SecurityToken(TokenType.API_KEY, apiKey);
    }

    public static SecurityToken forClientId(String clientId) {
        return new SecurityToken(TokenType.CLIENT_ID, clientId);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public static enum TokenType {
        CLIENT_ID,
        API_KEY,
        NONE;

    }
}

