/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.api.message;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.jupiter.api.message.Message;
import java.util.HashMap;
import java.util.Map;

public class DefaultMessage
implements Message {
    private Buffer content;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private HttpHeaders headers = HttpHeaders.create();

    public DefaultMessage(String content) {
        if (content != null) {
            this.content = Buffer.buffer(content);
        }
    }

    public static DefaultMessageBuilder builder() {
        return new DefaultMessageBuilder();
    }

    @Override
    public Buffer content() {
        return this.content;
    }

    @Override
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public DefaultMessage content(Buffer content) {
        this.content = content;
        return this;
    }

    @Override
    public DefaultMessage metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public DefaultMessage headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Buffer this$content = this.content();
        Buffer other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Map<String, Object> this$metadata = this.metadata();
        Map<String, Object> other$metadata = other.metadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Buffer $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Map<String, Object> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultMessage(content=" + this.content() + ", metadata=" + this.metadata() + ", headers=" + this.headers() + ")";
    }

    public DefaultMessage(Buffer content, Map<String, Object> metadata, HttpHeaders headers) {
        this.content = content;
        this.metadata = metadata;
        this.headers = headers;
    }

    public DefaultMessage() {
    }

    public static class DefaultMessageBuilder {
        private Buffer content;
        private Map<String, Object> metadata;
        private HttpHeaders headers;

        DefaultMessageBuilder() {
        }

        public DefaultMessageBuilder content(Buffer content) {
            this.content = content;
            return this;
        }

        public DefaultMessageBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public DefaultMessageBuilder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public DefaultMessage build() {
            return new DefaultMessage(this.content, this.metadata, this.headers);
        }

        public String toString() {
            return "DefaultMessage.DefaultMessageBuilder(content=" + this.content + ", metadata=" + this.metadata + ", headers=" + this.headers + ")";
        }
    }
}

