/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.api.connector;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.jupiter.api.ApiType;
import io.gravitee.gateway.jupiter.api.ConnectorMode;
import io.gravitee.gateway.jupiter.api.exception.PluginConfigurationException;
import java.util.Set;

public abstract class AbstractConnectorFactory<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Class<?> configurationClass;

    public abstract ApiType supportedApi();

    public abstract Set<ConnectorMode> supportedModes();

    public abstract T createConnector(String var1);

    protected <U> U getConfiguration(String configuration) throws PluginConfigurationException {
        try {
            if (configuration == null) {
                return (U)this.configurationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (U)OBJECT_MAPPER.readValue(configuration, this.configurationClass);
        }
        catch (Exception e) {
            throw new PluginConfigurationException("Failed to instantiate connector configuration", e);
        }
    }

    public AbstractConnectorFactory(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }
}

