/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.api;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;

public enum ListenerType {
    HTTP("http"),
    SUBSCRIPTION("subscription"),
    TCP("tcp");

    private static final Map<String, ListenerType> LABELS_MAP;
    @JsonValue
    private final String label;

    public static ListenerType fromLabel(String label) {
        if (label != null) {
            return LABELS_MAP.get(label);
        }
        return null;
    }

    private ListenerType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        LABELS_MAP = Map.of(ListenerType.HTTP.label, HTTP, ListenerType.SUBSCRIPTION.label, SUBSCRIPTION, ListenerType.TCP.label, TCP);
    }
}

