/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.api;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;

public enum ApiType {
    SYNC("sync"),
    ASYNC("async");

    private static final Map<String, ApiType> LABELS_MAP;
    @JsonValue
    private final String label;

    public static ApiType fromLabel(String label) {
        if (label != null) {
            return LABELS_MAP.get(label);
        }
        return null;
    }

    private ApiType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        LABELS_MAP = Map.of(ApiType.SYNC.label, SYNC, ApiType.ASYNC.label, ASYNC);
    }
}

