/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.el;

import io.gravitee.gateway.api.el.EmptyEvaluableSSLPrincipal;
import io.gravitee.gateway.api.el.EvaluableSSLPrincipal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class EvaluableSSLSession {
    private final SSLSession sslSession;
    public static final EmptyEvaluableSSLPrincipal EMPTY_EVALUABLE_SSL_PRINCIPAL = new EmptyEvaluableSSLPrincipal();

    public EvaluableSSLSession(SSLSession sslSession) {
        this.sslSession = sslSession;
    }

    public String getClientHost() {
        if (this.sslSession != null) {
            return this.sslSession.getPeerHost();
        }
        return null;
    }

    public Integer getClientPort() {
        if (this.sslSession != null) {
            return this.sslSession.getPeerPort();
        }
        return null;
    }

    public EvaluableSSLPrincipal getClient() {
        try {
            if (this.sslSession != null && this.sslSession.getPeerPrincipal() != null) {
                return new EvaluableSSLPrincipal(this.sslSession.getPeerPrincipal());
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        return EMPTY_EVALUABLE_SSL_PRINCIPAL;
    }

    public EvaluableSSLPrincipal getServer() {
        if (this.sslSession != null && this.sslSession.getLocalPrincipal() != null) {
            return new EvaluableSSLPrincipal(this.sslSession.getLocalPrincipal());
        }
        return EMPTY_EVALUABLE_SSL_PRINCIPAL;
    }
}

