/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel;

import io.gravitee.el.spel.CachedExpression;
import io.gravitee.el.spel.TemplateParserContext;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.plugin.cache.common.InMemoryCache;
import java.util.regex.Pattern;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;

public class SpelExpressionParser {
    private static final String EXPRESSION_PREFIX = "{#";
    private static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_REGEX = "\\{ *([#T(])((?>[^{}]+|\\{(?>[^{}]+)*\\})*\\})";
    private static final Pattern EXPRESSION_REGEX_PATTERN = Pattern.compile("\\{ *([#T(])((?>[^{}]+|\\{(?>[^{}]+)*\\})*\\})");
    private static final String EXPRESSION_REGEX_SUBSTITUTE = "{#$1$2";
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext("{#", "}");
    private org.springframework.expression.spel.standard.SpelExpressionParser expressionParser;
    protected static final Cache<String, CachedExpression> expressions;
    private static final int CACHE_EXPRESSION_MAX_SIZE = 20000;
    private static final int CACHE_EXPRESSION_IDLE_MILLIS = 3600000;

    public CachedExpression parseAndCacheExpression(String expression) {
        CachedExpression exp = (CachedExpression)expressions.get((Object)expression);
        if (exp != null) {
            return exp;
        }
        exp = new CachedExpression(this.parseExpression(expression));
        expressions.put((Object)expression, (Object)exp);
        return exp;
    }

    public Expression parseExpression(String expression) {
        return this.getParser().parseExpression(EXPRESSION_REGEX_PATTERN.matcher(expression).replaceAll(EXPRESSION_REGEX_SUBSTITUTE), PARSER_CONTEXT);
    }

    private org.springframework.expression.spel.standard.SpelExpressionParser getParser() {
        if (this.expressionParser == null) {
            this.expressionParser = new org.springframework.expression.spel.standard.SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, this.getClass().getClassLoader()));
        }
        return this.expressionParser;
    }

    static {
        CacheConfiguration cacheConfiguration = CacheConfiguration.builder().maxSize(20000L).timeToIdleInMs(3600000L).build();
        expressions = new InMemoryCache("el", cacheConfiguration);
    }
}

