/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateEngine;
import io.gravitee.el.exceptions.ExpressionEvaluationException;
import io.gravitee.el.spel.CachedExpression;
import io.gravitee.el.spel.SpelExpressionParser;
import io.gravitee.el.spel.context.SpelTemplateContext;
import io.reactivex.rxjava3.core.Maybe;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelEvaluationException;

public class SpelTemplateEngine
implements TemplateEngine {
    protected final SpelTemplateContext templateContext;
    private final SpelExpressionParser spelExpressionParser;

    public SpelTemplateEngine(SpelExpressionParser spelExpressionParser) {
        this.spelExpressionParser = spelExpressionParser;
        this.templateContext = new SpelTemplateContext();
    }

    @Override
    public <T> T getValue(String expression, Class<T> clazz) {
        return this.eval(this.spelExpressionParser.parseExpression(expression), this.templateContext.getContext(), clazz);
    }

    @Override
    public <T> Maybe<T> eval(String expression, Class<T> clazz) {
        try {
            CachedExpression cachedExpression = this.spelExpressionParser.parseAndCacheExpression(expression);
            return this.templateContext.evaluationContext(cachedExpression).flatMapMaybe(evaluationContext -> this.eval(cachedExpression, (EvaluationContext)evaluationContext, clazz));
        }
        catch (Exception e) {
            return Maybe.error((Throwable)e);
        }
    }

    @Override
    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    protected <T> Maybe<T> eval(CachedExpression exp, EvaluationContext evaluationContext, Class<T> clazz) {
        return Maybe.fromCallable(() -> this.eval(exp.getExpression(), evaluationContext, clazz));
    }

    protected <T> T eval(Expression expression, EvaluationContext evaluationContext, Class<T> clazz) {
        try {
            return (T)expression.getValue(evaluationContext, clazz);
        }
        catch (SpelEvaluationException spelEvaluationException) {
            throw new ExpressionEvaluationException(expression.getExpressionString(), spelEvaluationException);
        }
    }
}

