/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.expression.Expression;
import org.springframework.expression.common.CompositeStringExpression;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.CompoundExpression;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.VariableReference;
import org.springframework.expression.spel.standard.SpelExpression;

public class CachedExpression {
    private final Expression expression;
    private Set<String> variables;

    public CachedExpression(Expression expression) {
        this.expression = expression;
        this.computeVariables(expression);
    }

    private void computeVariables(Expression expression) {
        if (expression instanceof SpelExpression) {
            this.computeVariables(((SpelExpression)expression).getAST());
        } else if (expression instanceof CompositeStringExpression) {
            this.computeVariables((CompositeStringExpression)expression);
        }
    }

    private void computeVariables(CompositeStringExpression expression) {
        for (Expression e : expression.getExpressions()) {
            this.computeVariables(e);
        }
    }

    private void computeVariables(CompoundExpression expression) {
        for (int i = 0; i < expression.getChildCount(); ++i) {
            SpelNode node = expression.getChild(i);
            if (node instanceof VariableReference) {
                SpelNode attrNode;
                ++i;
                StringBuilder variableName = new StringBuilder(this.getVariableName((VariableReference)node));
                while (i < expression.getChildCount() && (attrNode = expression.getChild(i)) instanceof PropertyOrFieldReference) {
                    variableName.append(".").append(((PropertyOrFieldReference)attrNode).getName());
                    ++i;
                }
                --i;
                this.addVariable(variableName.toString());
                continue;
            }
            this.computeVariables(node);
        }
    }

    private void computeVariables(SpelNode spelNode) {
        if (spelNode instanceof CompoundExpression) {
            this.computeVariables((CompoundExpression)spelNode);
        } else if (spelNode instanceof VariableReference && spelNode.getChildCount() == 0) {
            this.addVariable(this.getVariableName((VariableReference)spelNode));
        } else {
            for (int i = 0; i < spelNode.getChildCount(); ++i) {
                this.computeVariables(spelNode.getChild(i));
            }
        }
    }

    private String getVariableName(VariableReference variableReference) {
        return variableReference.toStringAST().replace("#", "");
    }

    private void addVariable(String name) {
        if (this.variables == null) {
            this.variables = new HashSet<String>();
        }
        this.variables.add(name);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Set<String> getVariables() {
        if (this.variables == null) {
            return Collections.emptySet();
        }
        return this.variables;
    }
}

