/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.utils;

import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class RxHelper {
    public static final Predicate<Throwable> TRUE_PREDICATE = t -> true;
    public static final Predicate<Object> FALSE_PREDICATE = o -> false;

    public static <R> FlowableTransformer<R, R> mergeWithFirst(Flowable<R> other) {
        return upstream -> other.materialize().mergeWith((Publisher)upstream.materialize()).dematerialize(n -> n);
    }

    public static <R> FlowableTransformer<R, R> delayElement(int delay, TimeUnit timeUnit) {
        return RxHelper.delayElement(delay, timeUnit, FALSE_PREDICATE);
    }

    public static <R> FlowableTransformer<R, R> delayElement(int delay, TimeUnit timeUnit, Predicate<? super R> skipDelayPredicate) {
        return upstream -> upstream.concatMapSingle(e -> {
            if (skipDelayPredicate.test((Object)e)) {
                return Single.just((Object)e);
            }
            return Single.just((Object)e).delay((long)delay, timeUnit);
        });
    }

    public static <R> FlowableTransformer<R, R> retryFlowable(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retryFlowable(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> FlowableTransformer<R, R> retryFlowable(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, "retryPredicate is null");
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static <R> MaybeTransformer<R, R> retryMaybe(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retryMaybe(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> MaybeTransformer<R, R> retryMaybe(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static <R> SingleTransformer<R, R> retrySingle(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retrySingle(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> SingleTransformer<R, R> retrySingle(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static CompletableTransformer retry(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retry(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static CompletableTransformer retry(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, "retryPredicate is null");
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    private static <R extends Throwable> FlowableTransformer<R, R> takeThenThrow(int limit, Predicate<R> throwDirectlyPredicate) {
        AtomicInteger tries = new AtomicInteger(0);
        return upstream -> upstream.flatMapMaybe(throwable -> {
            if (tries.incrementAndGet() > limit || throwDirectlyPredicate.test(throwable)) {
                return Maybe.error((Throwable)throwable);
            }
            return Maybe.just((Object)throwable);
        });
    }

    private RxHelper() {
    }
}

