/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListUtils {
    private static final String COMMA_SEPARATOR = ",";
    private static final Pattern COMMA_SPLITTER = Pattern.compile(",");

    public static <T> List<T> toList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ListUtils.isJSONArray(string)) {
                JsonArray jsonArray = (JsonArray)Json.decodeValue((String)string);
                return jsonArray.getList().stream().map(Objects::toString).collect(Collectors.toUnmodifiableList());
            }
            String[] splits = COMMA_SPLITTER.split(string);
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = splits[i].trim();
            }
            return List.of(splits);
        }
        if (object instanceof Collection) {
            return List.copyOf((Collection)object);
        }
        if (object.getClass().isArray()) {
            return List.of((Object[])object);
        }
        return List.of(object);
    }

    private static boolean isJSONArray(String jsonCandidate) {
        String trimmedJsonCandidate = jsonCandidate.trim();
        return trimmedJsonCandidate.startsWith("[") && trimmedJsonCandidate.endsWith("]");
    }
}

