/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.templating;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerComponent {
    private static final Logger log = LoggerFactory.getLogger(FreeMarkerComponent.class);
    private final Configuration freeMarkerConfiguration;

    public FreeMarkerComponent(Path path, ClassLoader classLoader, String classLoaderTemplateBase) {
        this.freeMarkerConfiguration = FreeMarkerComponent.freemarkerConfiguration(path, classLoader, classLoaderTemplateBase);
    }

    public void generateFromTemplate(String templatePath, Map<String, Object> data, Writer writer) {
        try {
            log.debug("Generating from template {}", (Object)templatePath);
            Template template = this.freeMarkerConfiguration.getTemplate(templatePath);
            template.process(data, writer);
        }
        catch (TemplateException | IOException exception) {
            throw new IllegalArgumentException("Impossible to generate from template " + templatePath, exception);
        }
    }

    public String generateFromTemplate(String templatePath, Map<String, Object> data) {
        String string;
        StringWriter output = new StringWriter();
        try {
            this.generateFromTemplate(templatePath, data, output);
            string = output.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalArgumentException("Impossible to generate from template " + templatePath, exception);
            }
        }
        output.close();
        return string;
    }

    private static Configuration freemarkerConfiguration(Path path, ClassLoader classLoader, String classLoaderTemplateBase) {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        configuration.setDateFormat("iso_utc");
        configuration.setLocale(Locale.ENGLISH);
        configuration.setNumberFormat("computer");
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        configuration.setTemplateLoader(FreeMarkerComponent.templateLoader(path, classLoader, classLoaderTemplateBase));
        return configuration;
    }

    private static TemplateLoader templateLoader(Path path, ClassLoader classLoader, String classLoaderTemplateBase) {
        try {
            ArrayList<Object> templateLoaders = new ArrayList<Object>();
            if (path != null) {
                log.debug("Adding file template loader for path {}", (Object)path);
                templateLoaders.add(new FileTemplateLoader(path.toFile()));
            }
            if (classLoader != null) {
                log.debug("Adding classloader {} to freemarker template loaders", (Object)classLoader);
                if (classLoaderTemplateBase == null) {
                    log.debug("Classpath templates will be looked for in the root package");
                    templateLoaders.add(new ClassTemplateLoader(classLoader, "/"));
                } else {
                    log.debug("Classpath templates will be looked for in {}", (Object)classLoaderTemplateBase);
                    templateLoaders.add(new ClassTemplateLoader(classLoader, classLoaderTemplateBase));
                }
            }
            return new MultiTemplateLoader(templateLoaders.toArray(new TemplateLoader[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to initialize freemarker template loader", e);
        }
    }

    public static FreeMarkerComponentBuilder builder() {
        return new FreeMarkerComponentBuilder();
    }

    public static class FreeMarkerComponentBuilder {
        private Path path;
        private ClassLoader classLoader;
        private String classLoaderTemplateBase;

        FreeMarkerComponentBuilder() {
        }

        public FreeMarkerComponentBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public FreeMarkerComponentBuilder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public FreeMarkerComponentBuilder classLoaderTemplateBase(String classLoaderTemplateBase) {
            this.classLoaderTemplateBase = classLoaderTemplateBase;
            return this;
        }

        public FreeMarkerComponent build() {
            return new FreeMarkerComponent(this.path, this.classLoader, this.classLoaderTemplateBase);
        }

        public String toString() {
            return "FreeMarkerComponent.FreeMarkerComponentBuilder(path=" + this.path + ", classLoader=" + this.classLoader + ", classLoaderTemplateBase=" + this.classLoaderTemplateBase + ")";
        }
    }
}

