/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.spring.factory;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class SpringFactoriesLoader<T>
implements ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ApplicationContext applicationContext;
    private Collection<? extends T> factories;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected abstract Class<T> getObjectType();

    protected Collection<? extends T> getFactoriesInstances() {
        if (this.factories == null) {
            this.logger.debug("Loading instances for type {}", (Object)this.getObjectType().getName());
            this.factories = this.getSpringFactoriesInstances(this.getObjectType(), new Class[0], new Object[0]);
        } else {
            this.logger.debug("Instances for type {} already loaded. Skipping...", (Object)this.getObjectType().getName());
        }
        return this.factories;
    }

    private Collection<? extends T> getSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, Object ... args) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<String> names = new LinkedHashSet<String>(org.springframework.core.io.support.SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)classLoader));
        List<T> instances = this.createSpringFactoriesInstances(type, parameterTypes, classLoader, args, names);
        AnnotationAwareOrderComparator.sort(instances);
        return instances;
    }

    private <T> List<T> createSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, ClassLoader classLoader, Object[] args, Set<String> names) {
        ArrayList<Object> instances = new ArrayList<Object>(names.size());
        for (String name : names) {
            try {
                Class instanceClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
                Assert.isAssignable(type, (Class)instanceClass);
                Constructor constructor = instanceClass.getDeclaredConstructor(parameterTypes);
                Object instance = BeanUtils.instantiateClass(constructor, (Object[])args);
                ((AbstractApplicationContext)this.applicationContext).getBeanFactory().autowireBean(instance);
                if (instance instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)instance).setApplicationContext(this.applicationContext);
                }
                instances.add(instance);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Cannot instantiate " + type + " : " + name, ex);
            }
        }
        return instances;
    }
}

