/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.spring.factory;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractAutowiringFactoryBean<T>
extends AbstractFactoryBean<T>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected final T createInstance() throws Exception {
        T instance = this.doCreateInstance();
        if (instance != null) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean(instance);
            if (instance instanceof ApplicationContextAware) {
                ((ApplicationContextAware)instance).setApplicationContext(this.applicationContext);
            }
            if (instance instanceof InitializingBean) {
                ((InitializingBean)instance).afterPropertiesSet();
            }
        }
        return instance;
    }

    protected abstract T doCreateInstance() throws Exception;
}

