/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.security.jwt;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyJWT {
    private static final Logger log = LoggerFactory.getLogger(LazyJWT.class);
    private JWT jwt;
    private final String token;
    private Map<String, Object> headers;
    private Map<String, Object> claims;
    private boolean parsed = false;

    public LazyJWT(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public JWT getDelegate() {
        this.parse();
        return this.jwt;
    }

    public Map<String, Object> getHeaders() {
        if (this.parse()) {
            return this.headers;
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> getClaims() {
        if (this.parse()) {
            return this.claims;
        }
        return Collections.emptyMap();
    }

    private boolean parse() {
        if (!this.parsed) {
            this.parsed = true;
            try {
                this.jwt = JWTParser.parse((String)this.token);
                if (this.jwt.getHeader() != null) {
                    this.headers = this.jwt.getHeader().toJSONObject();
                }
                if (this.jwt.getJWTClaimsSet() != null) {
                    this.claims = this.jwt.getJWTClaimsSet().getClaims();
                }
            }
            catch (ParseException ex) {
                log.debug("Error while parsing JWT token", (Throwable)ex);
            }
        }
        return this.jwt != null;
    }
}

