/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.security;

import com.nimbusds.jose.util.Base64URL;
import io.gravitee.gateway.api.http.HttpHeaders;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CertificateUtils {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);

    public static Optional<X509Certificate> extractCertificate(HttpHeaders httpHeaders, String certHeader) {
        String certHeaderValue;
        Optional<X509Certificate> certificate = Optional.empty();
        String string = certHeaderValue = StringUtils.hasText((String)certHeader) ? httpHeaders.get((CharSequence)certHeader) : null;
        if (certHeaderValue != null) {
            try {
                if (!certHeaderValue.contains("\n")) {
                    certHeaderValue = URLDecoder.decode(certHeaderValue, Charset.defaultCharset());
                }
                certHeaderValue = certHeaderValue.replaceAll("\t", "\n");
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                certificate = Optional.ofNullable((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certHeaderValue.getBytes())));
            }
            catch (Exception e) {
                log.debug("Unable to retrieve peer certificate from request header '{}'", (Object)certHeader, (Object)e);
            }
        } else {
            log.debug("Header '{}' missing, unable to retrieve client certificate", (Object)certHeader);
        }
        return certificate;
    }

    public static Optional<X509Certificate> extractPeerCertificate(SSLSession sslSession) {
        Optional<X509Certificate> certificate = Optional.empty();
        if (sslSession != null) {
            try {
                Certificate[] peerCertificates = sslSession.getPeerCertificates();
                certificate = Optional.ofNullable((X509Certificate)peerCertificates[0]);
            }
            catch (Exception e) {
                log.debug("Unable to retrieve peer certificate from request", (Throwable)e);
            }
        } else {
            log.debug("No SSL session available to retrieve peer certificate");
        }
        return certificate;
    }

    public static String generateThumbprint(X509Certificate cert, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return Base64URL.encode((byte[])digest).toString();
        }
        catch (Exception e) {
            log.debug("Unable to generate thumbprint with given algorithm '{}'", (Object)algorithm, (Object)e);
            return null;
        }
    }

    private CertificateUtils() {
    }
}

