/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.cron;

import io.gravitee.common.utils.TimeProvider;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.SimpleTriggerContext;

public class CronTrigger {
    private static final Logger log = LoggerFactory.getLogger(CronTrigger.class);
    private final SimpleTriggerContext triggerContext;
    private final org.springframework.scheduling.support.CronTrigger delegate;

    public CronTrigger(String schedule) {
        this.delegate = new org.springframework.scheduling.support.CronTrigger(schedule);
        this.triggerContext = new SimpleTriggerContext(TimeProvider.clock());
    }

    public long nextExecutionIn() {
        Instant nextExecutionDate = this.delegate.nextExecution((TriggerContext)this.triggerContext);
        if (nextExecutionDate == null) {
            return Long.MAX_VALUE;
        }
        return ChronoUnit.MILLIS.between(TimeProvider.instantNow(), nextExecutionDate);
    }
}

