/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.utils;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationParser {
    private static final String SIMPLE_FORMAT_REGEX = "^([+-]?\\d+)([a-zA-Z]{0,2})$";
    private static Pattern simpleFormatPattern;

    public static Duration parse(String value) {
        Duration duration = null;
        if (DurationParser.stringNotEmpty(value)) {
            try {
                duration = Duration.parse(value);
            }
            catch (DateTimeParseException e) {
                try {
                    String suffix;
                    Matcher matcher = DurationParser.getSimpleFormatPattern().matcher(value);
                    if (matcher.matches() && DurationParser.stringNotEmpty(suffix = matcher.group(2))) {
                        Unit unit = Unit.fromSuffix(suffix);
                        duration = unit.parse(matcher.group(1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return duration;
    }

    private static boolean stringNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    private static Pattern getSimpleFormatPattern() {
        if (simpleFormatPattern == null) {
            simpleFormatPattern = Pattern.compile(SIMPLE_FORMAT_REGEX);
        }
        return simpleFormatPattern;
    }

    static enum Unit {
        MILLIS(ChronoUnit.MILLIS, "ms"),
        SECONDS(ChronoUnit.SECONDS, "s"),
        MINUTES(ChronoUnit.MINUTES, "m"),
        HOURS(ChronoUnit.HOURS, "h"),
        DAYS(ChronoUnit.DAYS, "d");

        private final ChronoUnit chronoUnit;
        private final String suffix;

        public Duration parse(String value) {
            return Duration.of(Long.parseLong(value), this.chronoUnit);
        }

        public static Unit fromSuffix(String suffix) {
            for (Unit candidate : Unit.values()) {
                if (!candidate.suffix.equalsIgnoreCase(suffix)) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Unknown unit '" + suffix + "'");
        }

        private Unit(ChronoUnit chronoUnit, String suffix) {
            this.chronoUnit = chronoUnit;
            this.suffix = suffix;
        }
    }
}

