/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.standalone.jetty;

import io.gravitee.node.api.configuration.Configuration;

public class JettyConfiguration {
    private final Configuration configuration;

    public JettyConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getHttpHost() {
        return this.configuration.getProperty("jetty.host", "0.0.0.0");
    }

    public int getHttpPort() {
        return (Integer)this.configuration.getProperty("jetty.port", Integer.class, (Object)8083);
    }

    public int getAcceptors() {
        return (Integer)this.configuration.getProperty("jetty.acceptors", Integer.class, (Object)-1);
    }

    public int getSelectors() {
        return (Integer)this.configuration.getProperty("jetty.selectors", Integer.class, (Object)-1);
    }

    public int getPoolMinThreads() {
        return (Integer)this.configuration.getProperty("jetty.pool.minThreads", Integer.class, (Object)10);
    }

    public int getPoolMaxThreads() {
        return (Integer)this.configuration.getProperty("jetty.pool.maxThreads", Integer.class, (Object)200);
    }

    public boolean isJmxEnabled() {
        return (Boolean)this.configuration.getProperty("jetty.jmx", Boolean.class, (Object)false);
    }

    public int getIdleTimeout() {
        return (Integer)this.configuration.getProperty("jetty.idleTimeout", Integer.class, (Object)30000);
    }

    public boolean isStatisticsEnabled() {
        return (Boolean)this.configuration.getProperty("jetty.statistics", Boolean.class, (Object)false);
    }

    public int getPoolIdleTimeout() {
        return (Integer)this.configuration.getProperty("jetty.pool.idleTimeout", Integer.class, (Object)60000);
    }

    public int getPoolQueueSize() {
        return (Integer)this.configuration.getProperty("jetty.pool.queueSize", Integer.class, (Object)6000);
    }

    public boolean isAccessLogEnabled() {
        return (Boolean)this.configuration.getProperty("jetty.accesslog.enabled", Boolean.class, (Object)true);
    }

    public String getAccessLogPath() {
        return this.configuration.getProperty("jetty.accesslog.path", this.configuration.getProperty("gravitee.home") + "/logs/gravitee_accesslog_yyyy_mm_dd.log");
    }

    public boolean isSecured() {
        return (Boolean)this.configuration.getProperty("jetty.secured", Boolean.class, (Object)false);
    }

    public String getKeyStorePath() {
        return this.configuration.getProperty("jetty.ssl.keystore.path");
    }

    public String getKeyStorePassword() {
        return this.configuration.getProperty("jetty.ssl.keystore.password");
    }

    public String getTrustStorePath() {
        return this.configuration.getProperty("jetty.ssl.truststore.path");
    }

    public String getTrustStorePassword() {
        return this.configuration.getProperty("jetty.ssl.truststore.password");
    }

    public String getKeyStoreType() {
        return this.configuration.getProperty("jetty.ssl.keystore.type");
    }

    public String getTrustStoreType() {
        return this.configuration.getProperty("jetty.ssl.truststore.type");
    }
}

