/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.services.sync.SyncManager;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledSyncService
extends AbstractService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ScheduledSyncService.class);
    @Autowired
    @Qualifier(value="syncTaskScheduler")
    private TaskScheduler scheduler;
    @Value(value="${services.sync.cron:*/5 * * * * *}")
    private String cronTrigger;
    @Value(value="${services.sync.enabled:true}")
    private boolean enabled;
    @Value(value="${services.local.enabled:false}")
    private boolean localRegistryEnabled;
    @Autowired
    private SyncManager syncStateManager;
    private final AtomicLong counter = new AtomicLong(0L);

    protected void doStart() throws Exception {
        if (!this.localRegistryEnabled) {
            if (this.enabled) {
                super.doStart();
                this.logger.info("Sync service has been initialized with cron [{}]", (Object)this.cronTrigger);
                this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
            } else {
                this.logger.warn("Sync service has been disabled");
            }
        } else {
            this.logger.warn("Sync service is disabled because local registry mode is enabled");
        }
    }

    @Override
    public void run() {
        this.doSync();
    }

    private void doSync() {
        this.logger.debug("Synchronization #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now().toString());
        this.syncStateManager.refresh();
        this.logger.debug("Synchronization #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now().toString());
    }

    protected String name() {
        return "Sync Service";
    }
}

